/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

class Histogram
implements Iterable<Map.Entry<Long, Long>> {
    private TreeMap<Long, Long> content = new TreeMap();
    private String name;
    private long totalCount;

    public Histogram() {
        this("(anonymous)");
    }

    public Histogram(String name) {
        this.name = name;
        this.totalCount = 0L;
    }

    public void dump(PrintStream stream) {
        stream.print("dumping Histogram " + this.name + ":\n");
        for (Map.Entry<Long, Long> ent : this) {
            stream.print("val/count pair: " + ent.getKey() + ", " + ent.getValue() + "\n");
        }
        stream.print("*** end *** \n");
    }

    @Override
    public Iterator<Map.Entry<Long, Long>> iterator() {
        return this.content.entrySet().iterator();
    }

    public long get(long key) {
        Long result = this.content.get(key);
        return result == null ? 0L : result;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public void enter(long value) {
        Long existingValue = this.content.get(value);
        if (existingValue == null) {
            this.content.put(value, 1L);
        } else {
            this.content.put(value, existingValue + 1L);
        }
        ++this.totalCount;
    }

    public long[] getCDF(int scale, int[] buckets) {
        if (this.totalCount == 0L) {
            return null;
        }
        long[] result = new long[buckets.length + 2];
        result[0] = this.content.firstEntry().getKey();
        result[buckets.length + 1] = this.content.lastEntry().getKey();
        Iterator<Map.Entry<Long, Long>> iter = this.content.entrySet().iterator();
        long cumulativeCount = 0L;
        int bucketCursor = 0;
        while (iter.hasNext()) {
            long targetCumulativeCount = (long)buckets[bucketCursor] * this.totalCount / (long)scale;
            Map.Entry<Long, Long> elt = iter.next();
            cumulativeCount += elt.getValue().longValue();
            while (cumulativeCount >= targetCumulativeCount) {
                result[bucketCursor + 1] = elt.getKey();
                if (++bucketCursor >= buckets.length) break;
                targetCumulativeCount = (long)buckets[bucketCursor] * this.totalCount / (long)scale;
            }
            if (bucketCursor != buckets.length) continue;
            break;
        }
        return result;
    }
}

