/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.tools.rumen.Hadoop20JHParser;
import org.apache.hadoop.tools.rumen.JobHistoryParser;
import org.apache.hadoop.tools.rumen.RewindableInputStream;

public class JobHistoryParserFactory {
    public static JobHistoryParser getParser(RewindableInputStream ris) throws IOException {
        for (VersionDetector vd : VersionDetector.values()) {
            boolean canParse = vd.canParse(ris);
            ris.rewind();
            if (!canParse) continue;
            return vd.newInstance(ris);
        }
        throw new IOException("No suitable parser.");
    }

    public static enum VersionDetector {
        Hadoop20{

            @Override
            public boolean canParse(InputStream input) throws IOException {
                return Hadoop20JHParser.canParse(input);
            }

            @Override
            public JobHistoryParser newInstance(InputStream input) throws IOException {
                return new Hadoop20JHParser(input);
            }
        };


        abstract JobHistoryParser newInstance(InputStream var1) throws IOException;

        abstract boolean canParse(InputStream var1) throws IOException;
    }
}

