/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.tools.rumen.LogRecordType;

class ParsedLine {
    Properties content = new Properties();
    LogRecordType type;
    static final String KEY = "(\\w+)";
    static final String VALUE = "([^\"\\\\]*+(?:\\\\.[^\"\\\\]*+)*+)";
    static final Pattern keyValPair = Pattern.compile("(\\w+)=\"([^\"\\\\]*+(?:\\\\.[^\"\\\\]*+)*+)\"");

    ParsedLine(String fullLine, int version) {
        int firstSpace = fullLine.indexOf(" ");
        if (firstSpace < 0) {
            firstSpace = fullLine.length();
        }
        if (firstSpace == 0) {
            return;
        }
        this.type = LogRecordType.intern(fullLine.substring(0, firstSpace));
        String propValPairs = fullLine.substring(firstSpace + 1);
        Matcher matcher = keyValPair.matcher(propValPairs);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            this.content.setProperty(key, value);
        }
    }

    protected LogRecordType getType() {
        return this.type;
    }

    protected String get(String key) {
        return this.content.getProperty(key);
    }

    protected long getLong(String key) {
        String val = this.get(key);
        return Long.parseLong(val);
    }
}

