/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal.cxf;

import java.util.Collections;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.CxfJaxrsServiceRegistrator;
import org.apache.aries.jax.rs.whiteboard.internal.cxf.CxfJaxrsServiceRegistratorTest$MyResource$;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CxfJaxrsServiceRegistratorTest {
    @Test
    public void unproxy() {
        JAXRSServerFactoryBean bean = (JAXRSServerFactoryBean)new CxfJaxrsServiceRegistrator(null, null, Collections.emptyMap(), null).createEndpoint(new Application(){

            public Set<Object> getSingletons() {
                return Collections.singleton(new MyResource$$Proxy());
            }
        }, JAXRSServerFactoryBean.class);
        bean.setStart(false);
        bean.create();
        Assertions.assertEquals(Collections.singletonList(MyResource.class), (Object)bean.getResourceClasses());
        ClassResourceInfo cri = (ClassResourceInfo)bean.getServiceFactory().getClassResourceInfo().iterator().next();
        Assertions.assertEquals(MyResource.class, (Object)cri.getServiceClass());
        Assertions.assertEquals(MyResource.class, (Object)cri.getResourceClass());
        Assertions.assertTrue((boolean)SingletonResourceProvider.class.isInstance(cri.getResourceProvider()));
    }

    @Test
    public void ignoreAppPAth() {
        JAXRSServerFactoryBean bean = (JAXRSServerFactoryBean)new CxfJaxrsServiceRegistrator(null, null, Collections.emptyMap(), null).createEndpoint((Application)new MyApp(), JAXRSServerFactoryBean.class);
        Assertions.assertEquals((Object)"/", (Object)bean.getAddress());
    }

    @Path(value="my")
    public static class MyResource {
        @GET
        public String get() {
            return "";
        }
    }

    @ApplicationPath(value="foo")
    public static class MyApp
    extends Application {
    }
}

