/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import org.apache.aries.jndi.ContextHelper;
import org.apache.aries.jndi.Tuple;
import org.apache.aries.jndi.Utils;
import org.apache.aries.util.service.registry.ServicePair;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFactoryHelper
implements ObjectFactory {
    protected BundleContext defaultContext;
    protected BundleContext callerContext;
    private static final Logger logger = Logger.getLogger(ObjectFactoryHelper.class.getName());

    public ObjectFactoryHelper(BundleContext defaultContext, BundleContext callerContext) {
        this.defaultContext = defaultContext;
        this.callerContext = callerContext;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        if (obj instanceof Referenceable) {
            obj = ((Referenceable)obj).getReference();
        }
        logger.log(Level.FINE, "obj = " + obj);
        Object result = obj;
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            String className = ref.getFactoryClassName();
            result = className != null ? this.getObjectInstanceUsingClassName(obj, className, obj, name, nameCtx, environment) : this.getObjectInstanceUsingRefAddress(ref.getAll(), obj, name, nameCtx, environment);
        }
        logger.log(Level.FINE, "Step 4: result = " + result);
        if (result == null || result == obj) {
            result = this.getObjectInstanceUsingObjectFactoryBuilders(obj, name, nameCtx, environment);
        }
        logger.log(Level.FINE, "Step 5: result = " + result);
        if ((result == null || result == obj) && (obj instanceof Reference && ((Reference)obj).getFactoryClassName() == null || !(obj instanceof Reference))) {
            result = this.getObjectInstanceUsingObjectFactories(obj, name, nameCtx, environment);
        }
        logger.log(Level.FINE, "Step 6: result = " + result);
        if (result == null || result == obj) {
            result = this.getObjectInstanceViaContextDotObjectFactories(obj, name, nameCtx, environment);
        }
        logger.log(Level.FINE, "Step 7: result = " + result);
        return result == null ? obj : result;
    }

    protected Object getObjectInstanceViaContextDotObjectFactories(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Object result = null;
        String factories = (String)environment.get("java.naming.factory.object");
        if (factories != null && factories.length() > 0) {
            String[] candidates = factories.split(":");
            ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            for (String cand : candidates) {
                ObjectFactory factory = null;
                try {
                    Class<?> clz = cl.loadClass(cand);
                    factory = (ObjectFactory)clz.newInstance();
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Exception instantiating factory: " + e);
                    continue;
                }
                logger.log(Level.FINE, "cand=" + cand + " factory=" + factory);
                if (factory != null) {
                    result = factory.getObjectInstance(obj, name, nameCtx, environment);
                }
                if (result != null && result != obj) break;
            }
        }
        return result == null ? obj : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getObjectInstanceUsingObjectFactories(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Object result = null;
        ServiceReference[] refs = Utils.getReferencesPrivileged(this.callerContext, ObjectFactory.class);
        if (refs != null) {
            Arrays.sort(refs, Utils.SERVICE_REFERENCE_COMPARATOR);
            for (ServiceReference ref : refs) {
                if (!this.canCallObjectFactory(obj, ref)) continue;
                ObjectFactory factory = (ObjectFactory)Utils.getServicePrivileged(this.callerContext, ref);
                try {
                    result = factory.getObjectInstance(obj, name, nameCtx, environment);
                }
                catch (NamingException ne) {
                }
                finally {
                    this.callerContext.ungetService(ref);
                }
                if (result != null && result != obj) break;
            }
        }
        return result == null ? obj : result;
    }

    private boolean canCallObjectFactory(Object obj, ServiceReference ref) {
        if (obj instanceof Reference) {
            return true;
        }
        Object prop = ref.getProperty("aries.object.factory.requires.reference");
        if (prop == null) {
            return true;
        }
        if (prop instanceof Boolean) {
            return (Boolean)prop == false;
        }
        return true;
    }

    protected static String getUrlScheme(String name) {
        String scheme = name;
        int index = name.indexOf(58);
        if (index != -1) {
            scheme = name.substring(0, index);
        }
        return scheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectInstanceUsingRefAddress(Enumeration<RefAddr> addresses, Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Object result = null;
        while (addresses.hasMoreElements()) {
            String urlScheme;
            ServicePair<ObjectFactory> factoryService;
            RefAddr address = addresses.nextElement();
            if (!(address instanceof StringRefAddr) || !"URL".equals(address.getType()) || (factoryService = ContextHelper.getURLObjectFactory(this.callerContext, urlScheme = ObjectFactoryHelper.getUrlScheme((String)address.getContent()), environment)) == null) continue;
            ObjectFactory factory = (ObjectFactory)factoryService.get();
            String value = (String)address.getContent();
            try {
                result = factory.getObjectInstance(value, name, nameCtx, environment);
            }
            finally {
                factoryService.unget();
            }
            if (result == null || result == obj) continue;
            break;
        }
        return result == null ? obj : result;
    }

    static Tuple<ServiceReference, ObjectFactory> findObjectFactoryByClassName(final BundleContext ctx, final String className) {
        return AccessController.doPrivileged(new PrivilegedAction<Tuple<ServiceReference, ObjectFactory>>(){

            @Override
            public Tuple<ServiceReference, ObjectFactory> run() {
                ServiceReference serviceReference = null;
                try {
                    ServiceReference[] refs = ctx.getServiceReferences(className, null);
                    if (refs != null && refs.length > 0) {
                        serviceReference = refs[0];
                    }
                }
                catch (InvalidSyntaxException e) {
                    throw new RuntimeException(Utils.MESSAGES.getMessage("null.is.invalid.filter", new Object[0]), e);
                }
                ObjectFactory factory = null;
                if (serviceReference != null) {
                    factory = (ObjectFactory)ctx.getService(serviceReference);
                }
                return new Tuple<ServiceReference, Object>(serviceReference, factory);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectInstanceUsingClassName(Object reference, String className, Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Tuple<ServiceReference, ObjectFactory> tuple = ObjectFactoryHelper.findObjectFactoryByClassName(this.defaultContext, className);
        Object result = null;
        if (tuple.second != null) {
            try {
                result = ((ObjectFactory)tuple.second).getObjectInstance(reference, name, nameCtx, environment);
            }
            finally {
                this.defaultContext.ungetService((ServiceReference)tuple.first);
            }
        }
        return result == null ? obj : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getObjectInstanceUsingObjectFactoryBuilders(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        ObjectFactory factory = null;
        ServiceReference[] refs = Utils.getReferencesPrivileged(this.callerContext, ObjectFactoryBuilder.class);
        if (refs != null) {
            Arrays.sort(refs, Utils.SERVICE_REFERENCE_COMPARATOR);
            for (ServiceReference ref : refs) {
                ObjectFactoryBuilder builder = (ObjectFactoryBuilder)Utils.getServicePrivileged(this.callerContext, ref);
                try {
                    factory = builder.createObjectFactory(obj, environment);
                }
                catch (NamingException e) {
                }
                finally {
                    this.callerContext.ungetService(ref);
                }
                if (factory != null) break;
            }
        }
        Object result = null;
        if (factory != null) {
            result = factory.getObjectInstance(obj, name, nameCtx, environment);
        }
        return result == null ? obj : result;
    }
}

