/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi.rmi;

import java.util.Hashtable;
import javax.naming.spi.ObjectFactory;
import org.apache.aries.util.AriesFrameworkUtil;
import org.apache.aries.util.nls.MessageUtil;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private ServiceRegistration reg;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Activator.class.getName());

    public void start(BundleContext context) {
        LOGGER.debug("Registering RMI url handler");
        try {
            Hashtable<String, String[]> props = new Hashtable<String, String[]>();
            props.put("osgi.jndi.url.scheme", new String[]{"rmi"});
            this.reg = context.registerService(ObjectFactory.class.getName(), ClassLoader.getSystemClassLoader().loadClass("com.sun.jndi.url.rmi.rmiURLContextFactory").newInstance(), props);
        }
        catch (Exception e) {
            MessageUtil msg = MessageUtil.createMessageUtil(Activator.class, (String)"org.apache.aries.jndi.nls.jndiRmiMessages");
            LOGGER.info(msg.getMessage("rmi.factory.creation.failed", new Object[0]), (Throwable)e);
        }
    }

    public void stop(BundleContext context) {
        AriesFrameworkUtil.safeUnregisterService((ServiceRegistration)this.reg);
    }
}

