/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.aries.rsa.topologymanager.importer.local;

import org.junit.Test;

import static org.junit.Assert.assertEquals;

import org.apache.aries.rsa.topologymanager.importer.local.ReferenceCounter;

public class ReferenceCounterTest {

    @Test
    public void testCounter() {
        ReferenceCounter<String> counter = new ReferenceCounter<String>();
        assertEquals(-1, counter.remove("a"));
        assertEquals(-1, counter.remove("a"));
        assertEquals(1, counter.add("a"));
        assertEquals(2, counter.add("a"));
        assertEquals(3, counter.add("a"));
        assertEquals(2, counter.remove("a"));
        assertEquals(1, counter.remove("a"));
        assertEquals(2, counter.add("a"));
        assertEquals(1, counter.remove("a"));
        assertEquals(0, counter.remove("a"));
        assertEquals(-1, counter.remove("a"));
    }
}
