/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.security.PrivilegedAction;
import java.util.EnumSet;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.RegionContextBundleHelper;
import org.apache.aries.subsystem.core.internal.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.service.subsystem.Subsystem;

public class GetBundleContextAction
implements PrivilegedAction<BundleContext> {
    private final BasicSubsystem subsystem;

    public GetBundleContextAction(BasicSubsystem subsystem) {
        this.subsystem = subsystem;
    }

    @Override
    public BundleContext run() {
        if (EnumSet.of(Subsystem.State.INSTALL_FAILED, Subsystem.State.UNINSTALLED).contains((Object)this.subsystem.getState())) {
            return null;
        }
        BasicSubsystem subsystem = Utils.findScopedSubsystemInRegion(this.subsystem);
        return subsystem.getRegion().getBundle("org.osgi.service.subsystem.region.context." + subsystem.getSubsystemId(), RegionContextBundleHelper.VERSION).getBundleContext();
    }
}

