/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.rewriter.util.JoinUtils;

public final class HybridToInMemoryHashJoinRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractBinaryJoinOperator joinOp;
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if ((op.getOperatorTag() == LogicalOperatorTag.INNERJOIN || op.getOperatorTag() == LogicalOperatorTag.LEFTOUTERJOIN) && (joinOp = (AbstractBinaryJoinOperator)op).getPhysicalOperator().getOperatorTag() == PhysicalOperatorTag.HYBRID_HASH_JOIN) {
            return JoinUtils.hybridToInMemHashJoin(joinOp, context);
        }
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }
}

