/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.asterix.om.util.container.ObjectFactories;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.CastTypeEvaluator;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractArrayProcessArraysEval
implements IScalarEvaluator {
    private final ArrayBackedValueStorage finalResult;
    private final ListAccessor listAccessor;
    private final IPointable tempList;
    private final IPointable[] listsArgs;
    private final IScalarEvaluator[] listsEval;
    private final SourceLocation sourceLocation;
    private final IObjectPool<IPointable, Void> pointablePool = new ListObjectPool(ObjectFactories.VOID_FACTORY);
    private final IObjectPool<IMutableValueStorage, Void> storageAllocator = new ListObjectPool(ObjectFactories.STORAGE_FACTORY);
    private final IAType[] argTypes;
    private final CastTypeEvaluator caster;
    private OrderedListBuilder orderedListBuilder = null;
    private UnorderedListBuilder unorderedListBuilder = null;

    AbstractArrayProcessArraysEval(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx, SourceLocation sourceLoc, IAType[] argTypes) throws HyracksDataException {
        this.finalResult = new ArrayBackedValueStorage();
        this.listAccessor = new ListAccessor();
        this.caster = new CastTypeEvaluator();
        this.tempList = new VoidPointable();
        this.listsArgs = new IPointable[args.length];
        this.listsEval = new IScalarEvaluator[args.length];
        for (int i = 0; i < args.length; ++i) {
            this.listsArgs[i] = new VoidPointable();
            this.listsEval[i] = args[i].createScalarEvaluator(ctx);
        }
        this.sourceLocation = sourceLoc;
        this.argTypes = argTypes;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        boolean isReturnNull = false;
        AbstractCollectionType outList = null;
        try {
            OrderedListBuilder listBuilder;
            for (int i = 0; i < this.listsEval.length; ++i) {
                this.listsEval[i].evaluate(tuple, this.tempList);
                if (PointableHelper.checkAndSetMissingOrNull(result, this.tempList)) {
                    if (result.getByteArray()[0] == ATypeTag.SERIALIZED_MISSING_TYPE_TAG) {
                        return;
                    }
                    isReturnNull = true;
                }
                if (isReturnNull) continue;
                byte listArgType = this.tempList.getByteArray()[this.tempList.getStartOffset()];
                ATypeTag listTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(listArgType);
                if (!listTag.isListType()) {
                    isReturnNull = true;
                    continue;
                }
                if (outList != null && outList.getTypeTag() != listTag) {
                    throw new RuntimeDataException(38, this.sourceLocation, new Serializable[0]);
                }
                if (outList == null) {
                    outList = (AbstractCollectionType)DefaultOpenFieldType.getDefaultOpenFieldType((ATypeTag)listTag);
                }
                this.caster.resetAndAllocate((IAType)outList, this.argTypes[i], this.listsEval[i]);
                this.caster.cast(this.tempList, this.listsArgs[i]);
            }
            if (isReturnNull) {
                PointableHelper.setNull(result);
                return;
            }
            if (outList.getTypeTag() == ATypeTag.ARRAY) {
                if (this.orderedListBuilder == null) {
                    this.orderedListBuilder = new OrderedListBuilder();
                }
                listBuilder = this.orderedListBuilder;
            } else {
                if (this.unorderedListBuilder == null) {
                    this.unorderedListBuilder = new UnorderedListBuilder();
                }
                listBuilder = this.unorderedListBuilder;
            }
            listBuilder.reset(outList);
            this.init();
            this.processLists(this.listsArgs, (IAsterixListBuilder)listBuilder);
            this.finish((IAsterixListBuilder)listBuilder);
            this.finalResult.reset();
            listBuilder.write(this.finalResult.getDataOutput(), true);
            result.set((IValueReference)this.finalResult);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            this.release();
            this.storageAllocator.reset();
            this.pointablePool.reset();
            this.caster.deallocatePointables();
        }
    }

    private void processLists(IPointable[] listsArgs, IAsterixListBuilder listBuilder) throws IOException {
        IPointable item = (IPointable)this.pointablePool.allocate(null);
        ArrayBackedValueStorage storage = (ArrayBackedValueStorage)this.storageAllocator.allocate(null);
        storage.reset();
        for (int listIndex = 0; listIndex < listsArgs.length; ++listIndex) {
            this.listAccessor.reset(listsArgs[listIndex].getByteArray(), listsArgs[listIndex].getStartOffset());
            for (int j = 0; j < this.listAccessor.size(); ++j) {
                boolean itemInStorage = this.listAccessor.getOrWriteItem(j, item, storage);
                boolean isUsingItem = this.processItem(item, listIndex, listBuilder);
                if (!isUsingItem) continue;
                item = (IPointable)this.pointablePool.allocate(null);
                if (!itemInStorage) continue;
                storage = (ArrayBackedValueStorage)this.storageAllocator.allocate(null);
                storage.reset();
            }
        }
    }

    protected abstract void init();

    protected abstract void finish(IAsterixListBuilder var1) throws HyracksDataException;

    protected abstract void release();

    protected abstract boolean processItem(IPointable var1, int var2, IAsterixListBuilder var3) throws HyracksDataException;
}

