/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.job;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.io.IWritable;

public class TaskAttemptDescriptor
implements IWritable,
Serializable {
    private static final long serialVersionUID = 1L;
    private TaskAttemptId taId;
    private int nPartitions;
    private int[] nInputPartitions;
    private int[] nOutputPartitions;
    private NetworkAddress[][] inputPartitionLocations;

    public static TaskAttemptDescriptor create(DataInput dis) throws IOException {
        TaskAttemptDescriptor taskAttemptDescriptor = new TaskAttemptDescriptor();
        taskAttemptDescriptor.readFields(dis);
        return taskAttemptDescriptor;
    }

    private TaskAttemptDescriptor() {
    }

    public TaskAttemptDescriptor(TaskAttemptId taId, int nPartitions, int[] nInputPartitions, int[] nOutputPartitions) {
        this.taId = taId;
        this.nPartitions = nPartitions;
        this.nInputPartitions = nInputPartitions;
        this.nOutputPartitions = nOutputPartitions;
    }

    public TaskAttemptId getTaskAttemptId() {
        return this.taId;
    }

    public int getPartitionCount() {
        return this.nPartitions;
    }

    public int[] getInputPartitionCounts() {
        return this.nInputPartitions;
    }

    public int[] getOutputPartitionCounts() {
        return this.nOutputPartitions;
    }

    public void setInputPartitionLocations(NetworkAddress[][] inputPartitionLocations) {
        this.inputPartitionLocations = inputPartitionLocations;
    }

    public NetworkAddress[][] getInputPartitionLocations() {
        return this.inputPartitionLocations;
    }

    public String toString() {
        return "TaskAttemptDescriptor[taId = " + this.taId + ", nPartitions = " + this.nPartitions + ", nInputPartitions = " + Arrays.toString(this.nInputPartitions) + ", nOutputPartitions = " + Arrays.toString(this.nOutputPartitions) + "]";
    }

    public void writeFields(DataOutput output) throws IOException {
        int i;
        this.taId.writeFields(output);
        output.writeInt(this.nPartitions);
        output.writeInt(this.nInputPartitions == null ? -1 : this.nInputPartitions.length);
        if (this.nInputPartitions != null) {
            for (i = 0; i < this.nInputPartitions.length; ++i) {
                output.writeInt(this.nInputPartitions[i]);
            }
        }
        output.writeInt(this.nOutputPartitions == null ? -1 : this.nOutputPartitions.length);
        if (this.nOutputPartitions != null) {
            for (i = 0; i < this.nOutputPartitions.length; ++i) {
                output.writeInt(this.nOutputPartitions[i]);
            }
        }
        output.writeInt(this.inputPartitionLocations == null ? -1 : this.inputPartitionLocations.length);
        if (this.inputPartitionLocations != null) {
            for (i = 0; i < this.inputPartitionLocations.length; ++i) {
                if (this.inputPartitionLocations[i] != null) {
                    output.writeInt(this.inputPartitionLocations[i].length);
                    for (int j = 0; j < this.inputPartitionLocations[i].length; ++j) {
                        this.inputPartitionLocations[i][j].writeFields(output);
                    }
                    continue;
                }
                output.writeInt(-1);
            }
        }
    }

    public void readFields(DataInput input) throws IOException {
        int addrCount;
        int outputCount;
        this.taId = TaskAttemptId.create((DataInput)input);
        this.nPartitions = input.readInt();
        int inputCount = input.readInt();
        if (inputCount >= 0) {
            this.nInputPartitions = new int[inputCount];
            for (int i = 0; i < this.nInputPartitions.length; ++i) {
                this.nInputPartitions[i] = input.readInt();
            }
        }
        if ((outputCount = input.readInt()) >= 0) {
            this.nOutputPartitions = new int[outputCount];
            for (int i = 0; i < this.nOutputPartitions.length; ++i) {
                this.nOutputPartitions[i] = input.readInt();
            }
        }
        if ((addrCount = input.readInt()) >= 0) {
            this.inputPartitionLocations = new NetworkAddress[addrCount][];
            for (int i = 0; i < this.inputPartitionLocations.length; ++i) {
                int columns = input.readInt();
                if (columns < 0) continue;
                this.inputPartitionLocations[i] = new NetworkAddress[columns];
                for (int j = 0; j < columns; ++j) {
                    this.inputPartitionLocations[i][j] = NetworkAddress.create((DataInput)input);
                }
            }
        }
    }
}

