/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.asterix.om.util.container.ObjectFactories;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public final class RewriteDistinctAggregateRule
implements IAlgebraicRewriteRule {
    private final IObjectPool<BitSet, Void> bitSetAllocator = new ListObjectPool(ObjectFactories.BIT_SET_FACTORY);
    private final Map<ILogicalExpression, BitSet> aggGroups = new LinkedHashMap<ILogicalExpression, BitSet>();
    private final List<AggregateOperator> newAggOps = new ArrayList<AggregateOperator>();

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        switch (op.getOperatorTag()) {
            case AGGREGATE: {
                if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, op)) {
                    return false;
                }
                this.newAggOps.clear();
                if (this.rewriteAggregate((AggregateOperator)op, this.newAggOps, context)) {
                    ILogicalOperator newOp = this.join(this.newAggOps, context);
                    opRef.setValue((Object)newOp);
                    return true;
                }
                return false;
            }
            case GROUP: {
                if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, op)) {
                    return false;
                }
                GroupByOperator gbyOp = (GroupByOperator)op;
                List nestedPlans = gbyOp.getNestedPlans();
                boolean applied = false;
                for (int i = nestedPlans.size() - 1; i >= 0; --i) {
                    ILogicalPlan nestedPlan = (ILogicalPlan)nestedPlans.get(i);
                    for (Mutable rootOpRef : nestedPlan.getRoots()) {
                        ILogicalOperator rootOp = (ILogicalOperator)rootOpRef.getValue();
                        if (rootOp.getOperatorTag() != LogicalOperatorTag.AGGREGATE) continue;
                        this.newAggOps.clear();
                        if (!this.rewriteAggregate((AggregateOperator)rootOp, this.newAggOps, context)) continue;
                        applied = true;
                        rootOpRef.setValue((Object)this.newAggOps.get(0));
                        int ln = this.newAggOps.size();
                        for (int j = 1; j < ln; ++j) {
                            nestedPlans.add(new ALogicalPlanImpl((Mutable)new MutableObject((Object)this.newAggOps.get(j))));
                        }
                    }
                }
                if (applied) {
                    context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)gbyOp);
                    context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)gbyOp);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private ILogicalOperator join(List<? extends ILogicalOperator> ops, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator resultOp = ops.get(0);
        int n = ops.size();
        for (int i = 1; i < n; ++i) {
            ILogicalOperator op = ops.get(i);
            InnerJoinOperator joinOp = new InnerJoinOperator((Mutable)new MutableObject((Object)ConstantExpression.TRUE));
            joinOp.setSourceLocation(resultOp.getSourceLocation());
            joinOp.getInputs().add(new MutableObject((Object)resultOp));
            joinOp.getInputs().add(new MutableObject((Object)op));
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)joinOp);
            resultOp = joinOp;
        }
        return resultOp;
    }

    private boolean rewriteAggregate(AggregateOperator aggOp, List<AggregateOperator> outAggOps, IOptimizationContext context) throws AlgebricksException {
        BitSet argIndexes;
        this.aggGroups.clear();
        this.bitSetAllocator.reset();
        List aggExprs = aggOp.getExpressions();
        int aggCount = aggExprs.size();
        int distinctAggCount = 0;
        for (int i = 0; i < aggCount; ++i) {
            AbstractFunctionCallExpression callExpr;
            FunctionIdentifier aggFn;
            ILogicalExpression aggExpr = (ILogicalExpression)((Mutable)aggExprs.get(i)).getValue();
            ILogicalExpression distinctValueExpr = null;
            if (aggExpr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && BuiltinFunctions.getAggregateFunctionForDistinct((FunctionIdentifier)(aggFn = (callExpr = (AbstractFunctionCallExpression)aggExpr).getFunctionIdentifier())) != null) {
                distinctValueExpr = (ILogicalExpression)((Mutable)callExpr.getArguments().get(0)).getValue();
                ++distinctAggCount;
            }
            if ((argIndexes = this.aggGroups.get(distinctValueExpr)) == null) {
                argIndexes = (BitSet)this.bitSetAllocator.allocate(null);
                argIndexes.clear();
                this.aggGroups.put(distinctValueExpr, argIndexes);
            }
            argIndexes.set(i);
        }
        if (distinctAggCount == 0) {
            return false;
        }
        Iterator<Map.Entry<ILogicalExpression, BitSet>> i = this.aggGroups.entrySet().iterator();
        while (i.hasNext()) {
            AggregateOperator newAggOp;
            Map.Entry<ILogicalExpression, BitSet> me = i.next();
            boolean isDistinct = me.getKey() != null;
            argIndexes = me.getValue();
            if (i.hasNext()) {
                newAggOp = (AggregateOperator)OperatorManipulationUtil.deepCopyWithNewVars((ILogicalOperator)aggOp, (IOptimizationContext)context).first;
                newAggOp.getVariables().clear();
                newAggOp.getVariables().addAll(aggOp.getVariables());
            } else {
                newAggOp = aggOp;
            }
            OperatorManipulationUtil.retainAssignVariablesAndExpressions((List)newAggOp.getVariables(), (List)newAggOp.getExpressions(), (BitSet)argIndexes);
            if (isDistinct) {
                this.rewriteDistinctAggregate(newAggOp, context);
            }
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newAggOp);
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)newAggOp);
            outAggOps.add(newAggOp);
        }
        return true;
    }

    private void rewriteDistinctAggregate(AggregateOperator aggOp, IOptimizationContext context) throws AlgebricksException {
        LogicalVariable distinctVar;
        ILogicalOperator inputOp = (ILogicalOperator)((Mutable)aggOp.getInputs().get(0)).getValue();
        ILogicalExpression distinctExpr = (ILogicalExpression)((Mutable)((AbstractFunctionCallExpression)((Mutable)aggOp.getExpressions().get(0)).getValue()).getArguments().get(0)).getValue();
        AssignOperator assignOp = null;
        if (distinctExpr.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
            distinctVar = ((VariableReferenceExpression)distinctExpr).getVariableReference();
        } else {
            distinctVar = context.newVar();
            assignOp = new AssignOperator(distinctVar, (Mutable)new MutableObject((Object)distinctExpr));
            assignOp.setSourceLocation(aggOp.getSourceLocation());
            assignOp.getInputs().add(new MutableObject((Object)inputOp));
            assignOp.setExecutionMode(inputOp.getExecutionMode());
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOp);
            inputOp = assignOp;
        }
        VariableReferenceExpression distinctVarRef = new VariableReferenceExpression(distinctVar);
        distinctVarRef.setSourceLocation(distinctExpr.getSourceLocation());
        ArrayList<MutableObject> distinctExprs = new ArrayList<MutableObject>(1);
        distinctExprs.add(new MutableObject((Object)distinctVarRef));
        DistinctOperator distinctOp = new DistinctOperator(distinctExprs);
        distinctOp.setSourceLocation(aggOp.getSourceLocation());
        distinctOp.getInputs().add(new MutableObject((Object)inputOp));
        distinctOp.setExecutionMode(inputOp.getExecutionMode());
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)distinctOp);
        for (Mutable aggExprRef : aggOp.getExpressions()) {
            AbstractFunctionCallExpression callExpr = (AbstractFunctionCallExpression)aggExprRef.getValue();
            FunctionIdentifier regularAggForDistinct = BuiltinFunctions.getAggregateFunctionForDistinct((FunctionIdentifier)callExpr.getFunctionIdentifier());
            if (regularAggForDistinct == null) {
                throw new IllegalStateException(String.valueOf(callExpr.getFunctionIdentifier()));
            }
            callExpr.setFunctionInfo((IFunctionInfo)BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)regularAggForDistinct));
            if (assignOp == null) continue;
            ((Mutable)callExpr.getArguments().get(0)).setValue((Object)distinctVarRef.cloneExpression());
        }
        aggOp.getInputs().clear();
        aggOp.getInputs().add(new MutableObject((Object)distinctOp));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)aggOp);
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }
}

