/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.utils;

import java.io.Serializable;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.data.std.primitive.DoublePointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.btree.frames.BTreeNSMInteriorFrameFactory;
import org.apache.hyracks.storage.am.btree.frames.BTreeNSMLeafFrameFactory;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.tuples.BTreeTypeAwareTupleWriterFactory;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriterFactory;
import org.apache.hyracks.storage.am.common.tuples.TypeAwareTupleWriterFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentFilterHelper;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMPageWriteCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.frames.LSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.BTreeFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.ComponentFilterHelper;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.am.lsm.rtree.impls.ExternalRTree;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTree;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeFileManager;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeWithAntiMatterTuples;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeWithAntiMatterTuplesDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeWithAntiMatterTuplesFileManager;
import org.apache.hyracks.storage.am.lsm.rtree.impls.RTreeFactory;
import org.apache.hyracks.storage.am.lsm.rtree.tuples.LSMRTreeCopyTupleWriterFactory;
import org.apache.hyracks.storage.am.lsm.rtree.tuples.LSMRTreeTupleWriterFactory;
import org.apache.hyracks.storage.am.lsm.rtree.tuples.LSMRTreeTupleWriterFactoryForPointMBR;
import org.apache.hyracks.storage.am.rtree.frames.RTreeFrameFactory;
import org.apache.hyracks.storage.am.rtree.frames.RTreeNSMInteriorFrameFactory;
import org.apache.hyracks.storage.am.rtree.frames.RTreeNSMLeafFrameFactory;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;
import org.apache.hyracks.storage.am.rtree.linearize.HilbertDoubleComparatorFactory;
import org.apache.hyracks.storage.am.rtree.linearize.ZCurveDoubleComparatorFactory;
import org.apache.hyracks.storage.am.rtree.linearize.ZCurveIntComparatorFactory;
import org.apache.hyracks.storage.am.rtree.tuples.RTreeTypeAwareTupleWriterFactory;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.util.trace.ITracer;

public class LSMRTreeUtils {
    public static LSMRTree createLSMTree(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, FileReference file, IBufferCache diskBufferCache, ITypeTraits[] typeTraits, IBinaryComparatorFactory[] rtreeCmpFactories, IBinaryComparatorFactory[] btreeCmpFactories, IPrimitiveValueProviderFactory[] valueProviderFactories, RTreePolicyType rtreePolicyType, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallbackFactory ioOpCallbackFactory, ILSMPageWriteCallbackFactory pageWriteCallbackFactory, ILinearizeComparatorFactory linearizeCmpFactory, int[] rtreeFields, int[] buddyBTreeFields, ITypeTraits[] filterTypeTraits, IBinaryComparatorFactory[] filterCmpFactories, int[] filterFields, boolean durable, boolean isPointMBR, IMetadataPageManagerFactory freePageManagerFactory) throws HyracksDataException {
        int valueFieldCount = buddyBTreeFields.length;
        int keyFieldCount = typeTraits.length - valueFieldCount;
        ITypeTraits[] btreeTypeTraits = new ITypeTraits[valueFieldCount];
        for (int i = 0; i < valueFieldCount; ++i) {
            btreeTypeTraits[i] = typeTraits[buddyBTreeFields[i]];
        }
        RTreeTypeAwareTupleWriterFactory rtreeInteriorFrameTupleWriterFactory = new RTreeTypeAwareTupleWriterFactory(typeTraits);
        RTreeTypeAwareTupleWriterFactory rtreeLeafFrameTupleWriterFactory = null;
        rtreeLeafFrameTupleWriterFactory = isPointMBR ? new LSMRTreeTupleWriterFactoryForPointMBR(typeTraits, keyFieldCount, valueFieldCount, false, false) : rtreeInteriorFrameTupleWriterFactory;
        BTreeTypeAwareTupleWriterFactory btreeTupleWriterFactory = new BTreeTypeAwareTupleWriterFactory(btreeTypeTraits, false);
        RTreeNSMInteriorFrameFactory rtreeInteriorFrameFactory = new RTreeNSMInteriorFrameFactory(rtreeInteriorFrameTupleWriterFactory, valueProviderFactories, rtreePolicyType, isPointMBR);
        RTreeNSMLeafFrameFactory rtreeLeafFrameFactory = new RTreeNSMLeafFrameFactory(rtreeLeafFrameTupleWriterFactory, valueProviderFactories, rtreePolicyType, isPointMBR);
        BTreeNSMInteriorFrameFactory btreeInteriorFrameFactory = new BTreeNSMInteriorFrameFactory((TypeAwareTupleWriterFactory)btreeTupleWriterFactory);
        BTreeNSMLeafFrameFactory btreeLeafFrameFactory = new BTreeNSMLeafFrameFactory((TypeAwareTupleWriterFactory)btreeTupleWriterFactory);
        RTreeFactory diskRTreeFactory = new RTreeFactory(ioManager, diskBufferCache, freePageManagerFactory, (ITreeIndexFrameFactory)rtreeInteriorFrameFactory, (ITreeIndexFrameFactory)rtreeLeafFrameFactory, rtreeCmpFactories, typeTraits.length, isPointMBR);
        BTreeFactory diskBTreeFactory = new BTreeFactory(ioManager, diskBufferCache, (IPageManagerFactory)freePageManagerFactory, (ITreeIndexFrameFactory)btreeInteriorFrameFactory, (ITreeIndexFrameFactory)btreeLeafFrameFactory, btreeCmpFactories, btreeTypeTraits.length);
        int[] comparatorFields = new int[]{0};
        IBinaryComparatorFactory[] linearizerArray = new IBinaryComparatorFactory[]{linearizeCmpFactory};
        int[] bloomFilterKeyFields = new int[btreeCmpFactories.length];
        for (int i = 0; i < btreeCmpFactories.length; ++i) {
            bloomFilterKeyFields[i] = i;
        }
        BloomFilterFactory bloomFilterFactory = new BloomFilterFactory(diskBufferCache, bloomFilterKeyFields);
        ComponentFilterHelper filterHelper = null;
        LSMComponentFilterFrameFactory filterFrameFactory = null;
        LSMComponentFilterManager filterManager = null;
        if (filterCmpFactories != null) {
            TypeAwareTupleWriterFactory filterTupleWriterFactory = new TypeAwareTupleWriterFactory(filterTypeTraits);
            filterHelper = new ComponentFilterHelper((ITreeIndexTupleWriterFactory)filterTupleWriterFactory, filterCmpFactories);
            filterFrameFactory = new LSMComponentFilterFrameFactory((ITreeIndexTupleWriterFactory)filterTupleWriterFactory);
            filterManager = new LSMComponentFilterManager((ILSMComponentFilterFrameFactory)filterFrameFactory);
        }
        LSMRTreeFileManager fileNameManager = new LSMRTreeFileManager(ioManager, file, diskRTreeFactory, (TreeIndexFactory<? extends ITreeIndex>)diskBTreeFactory);
        LSMRTreeDiskComponentFactory componentFactory = new LSMRTreeDiskComponentFactory(diskRTreeFactory, (TreeIndexFactory<BTree>)diskBTreeFactory, bloomFilterFactory, (IComponentFilterHelper)filterHelper);
        return new LSMRTree(ioManager, virtualBufferCaches, (RTreeFrameFactory)rtreeInteriorFrameFactory, (RTreeFrameFactory)rtreeLeafFrameFactory, (ITreeIndexFrameFactory)btreeInteriorFrameFactory, (ITreeIndexFrameFactory)btreeLeafFrameFactory, diskBufferCache, (ILSMIndexFileManager)fileNameManager, (ILSMDiskComponentFactory)componentFactory, (IComponentFilterHelper)filterHelper, (ILSMComponentFilterFrameFactory)filterFrameFactory, filterManager, bloomFilterFalsePositiveRate, typeTraits.length, rtreeCmpFactories, btreeCmpFactories, linearizeCmpFactory, comparatorFields, linearizerArray, mergePolicy, opTracker, ioScheduler, ioOpCallbackFactory, pageWriteCallbackFactory, rtreeFields, buddyBTreeFields, filterFields, durable, isPointMBR);
    }

    public static LSMRTreeWithAntiMatterTuples createLSMTreeWithAntiMatterTuples(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, FileReference file, IBufferCache diskBufferCache, ITypeTraits[] typeTraits, IBinaryComparatorFactory[] rtreeCmpFactories, IBinaryComparatorFactory[] btreeComparatorFactories, IPrimitiveValueProviderFactory[] valueProviderFactories, RTreePolicyType rtreePolicyType, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallbackFactory ioOpCallbackFactory, ILSMPageWriteCallbackFactory pageWriteCallbackFactory, ILinearizeComparatorFactory linearizerCmpFactory, int[] rtreeFields, ITypeTraits[] filterTypeTraits, IBinaryComparatorFactory[] filterCmpFactories, int[] filterFields, boolean durable, boolean isPointMBR, IMetadataPageManagerFactory freePageManagerFactory) throws HyracksDataException {
        RTreeTypeAwareTupleWriterFactory rtreeLeafFrameBulkLoadWriterFactory;
        RTreeTypeAwareTupleWriterFactory rtreeLeafFrameCopyTupleWriterFactory;
        RTreeTypeAwareTupleWriterFactory rtreeLeafFrameTupleWriterFactory;
        LSMRTreeTupleWriterFactory rtreeInteriorFrameTupleWriterFactory = new LSMRTreeTupleWriterFactory(typeTraits, false);
        if (isPointMBR) {
            int keyFieldCount = rtreeCmpFactories.length;
            int valueFieldCount = btreeComparatorFactories.length - keyFieldCount;
            rtreeLeafFrameTupleWriterFactory = new LSMRTreeTupleWriterFactoryForPointMBR(typeTraits, keyFieldCount, valueFieldCount, true, false);
            rtreeLeafFrameCopyTupleWriterFactory = new LSMRTreeTupleWriterFactoryForPointMBR(typeTraits, keyFieldCount, valueFieldCount, true, false);
            rtreeLeafFrameBulkLoadWriterFactory = new LSMRTreeTupleWriterFactoryForPointMBR(typeTraits, keyFieldCount, valueFieldCount, true, false);
        } else {
            rtreeLeafFrameTupleWriterFactory = new LSMRTreeTupleWriterFactory(typeTraits, false);
            rtreeLeafFrameCopyTupleWriterFactory = new LSMRTreeCopyTupleWriterFactory(typeTraits);
            rtreeLeafFrameBulkLoadWriterFactory = new LSMRTreeTupleWriterFactory(typeTraits, false);
        }
        LSMRTreeTupleWriterFactory btreeTupleWriterFactory = new LSMRTreeTupleWriterFactory(typeTraits, true);
        RTreeNSMInteriorFrameFactory rtreeInteriorFrameFactory = new RTreeNSMInteriorFrameFactory((RTreeTypeAwareTupleWriterFactory)rtreeInteriorFrameTupleWriterFactory, valueProviderFactories, rtreePolicyType, isPointMBR);
        RTreeNSMLeafFrameFactory rtreeLeafFrameFactory = new RTreeNSMLeafFrameFactory(rtreeLeafFrameTupleWriterFactory, valueProviderFactories, rtreePolicyType, isPointMBR);
        RTreeNSMLeafFrameFactory rtreeLeafFrameBulkLoadFactory = new RTreeNSMLeafFrameFactory(rtreeLeafFrameBulkLoadWriterFactory, valueProviderFactories, rtreePolicyType, isPointMBR);
        BTreeNSMInteriorFrameFactory btreeInteriorFrameFactory = new BTreeNSMInteriorFrameFactory((TypeAwareTupleWriterFactory)btreeTupleWriterFactory);
        BTreeNSMLeafFrameFactory btreeLeafFrameFactory = new BTreeNSMLeafFrameFactory((TypeAwareTupleWriterFactory)btreeTupleWriterFactory);
        RTreeNSMLeafFrameFactory copyTupleLeafFrameFactory = new RTreeNSMLeafFrameFactory(rtreeLeafFrameCopyTupleWriterFactory, valueProviderFactories, rtreePolicyType, isPointMBR);
        RTreeFactory diskRTreeFactory = new RTreeFactory(ioManager, diskBufferCache, freePageManagerFactory, (ITreeIndexFrameFactory)rtreeInteriorFrameFactory, (ITreeIndexFrameFactory)copyTupleLeafFrameFactory, rtreeCmpFactories, typeTraits.length, isPointMBR);
        RTreeFactory bulkLoadRTreeFactory = new RTreeFactory(ioManager, diskBufferCache, freePageManagerFactory, (ITreeIndexFrameFactory)rtreeInteriorFrameFactory, (ITreeIndexFrameFactory)rtreeLeafFrameBulkLoadFactory, rtreeCmpFactories, typeTraits.length, isPointMBR);
        int[] comparatorFields = new int[btreeComparatorFactories.length - rtreeCmpFactories.length + 1];
        IBinaryComparatorFactory[] linearizerArray = new IBinaryComparatorFactory[btreeComparatorFactories.length - rtreeCmpFactories.length + 1];
        comparatorFields[0] = 0;
        for (int i = 1; i < comparatorFields.length; ++i) {
            comparatorFields[i] = rtreeCmpFactories.length - 1 + i;
        }
        linearizerArray[0] = linearizerCmpFactory;
        int j = 1;
        for (int i = rtreeCmpFactories.length; i < btreeComparatorFactories.length; ++i) {
            linearizerArray[j] = btreeComparatorFactories[i];
            ++j;
        }
        ComponentFilterHelper filterHelper = null;
        LSMComponentFilterFrameFactory filterFrameFactory = null;
        LSMComponentFilterManager filterManager = null;
        if (filterCmpFactories != null) {
            TypeAwareTupleWriterFactory filterTupleWriterFactory = new TypeAwareTupleWriterFactory(filterTypeTraits);
            filterHelper = new ComponentFilterHelper((ITreeIndexTupleWriterFactory)filterTupleWriterFactory, filterCmpFactories);
            filterFrameFactory = new LSMComponentFilterFrameFactory((ITreeIndexTupleWriterFactory)filterTupleWriterFactory);
            filterManager = new LSMComponentFilterManager((ILSMComponentFilterFrameFactory)filterFrameFactory);
        }
        LSMRTreeWithAntiMatterTuplesFileManager fileNameManager = new LSMRTreeWithAntiMatterTuplesFileManager(ioManager, file, diskRTreeFactory);
        LSMRTreeWithAntiMatterTuplesDiskComponentFactory componentFactory = new LSMRTreeWithAntiMatterTuplesDiskComponentFactory(diskRTreeFactory, (IComponentFilterHelper)filterHelper);
        LSMRTreeWithAntiMatterTuplesDiskComponentFactory bulkLoadComponentFactory = new LSMRTreeWithAntiMatterTuplesDiskComponentFactory(bulkLoadRTreeFactory, (IComponentFilterHelper)filterHelper);
        return new LSMRTreeWithAntiMatterTuples(ioManager, virtualBufferCaches, (RTreeFrameFactory)rtreeInteriorFrameFactory, (RTreeFrameFactory)rtreeLeafFrameFactory, (ITreeIndexFrameFactory)btreeInteriorFrameFactory, (ITreeIndexFrameFactory)btreeLeafFrameFactory, diskBufferCache, (ILSMIndexFileManager)fileNameManager, componentFactory, bulkLoadComponentFactory, (IComponentFilterHelper)filterHelper, (ILSMComponentFilterFrameFactory)filterFrameFactory, filterManager, typeTraits.length, rtreeCmpFactories, btreeComparatorFactories, linearizerCmpFactory, comparatorFields, linearizerArray, mergePolicy, opTracker, ioScheduler, ioOpCallbackFactory, pageWriteCallbackFactory, rtreeFields, filterFields, durable, isPointMBR);
    }

    public static ExternalRTree createExternalRTree(IIOManager ioManager, FileReference file, IBufferCache diskBufferCache, ITypeTraits[] typeTraits, IBinaryComparatorFactory[] rtreeCmpFactories, IBinaryComparatorFactory[] btreeCmpFactories, IPrimitiveValueProviderFactory[] valueProviderFactories, RTreePolicyType rtreePolicyType, double bloomFilterFalsePositiveRate, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallbackFactory ioOpCallbackFactory, ILSMPageWriteCallbackFactory pageWriteCallbackFactory, ILinearizeComparatorFactory linearizeCmpFactory, int[] buddyBTreeFields, boolean durable, boolean isPointMBR, IMetadataPageManagerFactory freePageManagerFactory, ITracer tracer) throws HyracksDataException {
        int keyFieldCount = rtreeCmpFactories.length;
        int valueFieldCount = typeTraits.length - keyFieldCount;
        ITypeTraits[] btreeTypeTraits = new ITypeTraits[valueFieldCount];
        for (int i = 0; i < buddyBTreeFields.length; ++i) {
            btreeTypeTraits[i] = typeTraits[buddyBTreeFields[i]];
        }
        RTreeTypeAwareTupleWriterFactory rtreeInteriorFrameTupleWriterFactory = new RTreeTypeAwareTupleWriterFactory(typeTraits);
        RTreeTypeAwareTupleWriterFactory rtreeLeafFrameTupleWriterFactory = null;
        rtreeLeafFrameTupleWriterFactory = isPointMBR ? new LSMRTreeTupleWriterFactoryForPointMBR(typeTraits, keyFieldCount, valueFieldCount, false, false) : rtreeInteriorFrameTupleWriterFactory;
        BTreeTypeAwareTupleWriterFactory btreeTupleWriterFactory = new BTreeTypeAwareTupleWriterFactory(btreeTypeTraits, false);
        RTreeNSMInteriorFrameFactory rtreeInteriorFrameFactory = new RTreeNSMInteriorFrameFactory(rtreeInteriorFrameTupleWriterFactory, valueProviderFactories, rtreePolicyType, isPointMBR);
        RTreeNSMLeafFrameFactory rtreeLeafFrameFactory = new RTreeNSMLeafFrameFactory(rtreeLeafFrameTupleWriterFactory, valueProviderFactories, rtreePolicyType, isPointMBR);
        BTreeNSMInteriorFrameFactory btreeInteriorFrameFactory = new BTreeNSMInteriorFrameFactory((TypeAwareTupleWriterFactory)btreeTupleWriterFactory);
        BTreeNSMLeafFrameFactory btreeLeafFrameFactory = new BTreeNSMLeafFrameFactory((TypeAwareTupleWriterFactory)btreeTupleWriterFactory);
        RTreeFactory diskRTreeFactory = new RTreeFactory(ioManager, diskBufferCache, freePageManagerFactory, (ITreeIndexFrameFactory)rtreeInteriorFrameFactory, (ITreeIndexFrameFactory)rtreeLeafFrameFactory, rtreeCmpFactories, typeTraits.length, isPointMBR);
        BTreeFactory diskBTreeFactory = new BTreeFactory(ioManager, diskBufferCache, (IPageManagerFactory)freePageManagerFactory, (ITreeIndexFrameFactory)btreeInteriorFrameFactory, (ITreeIndexFrameFactory)btreeLeafFrameFactory, btreeCmpFactories, btreeTypeTraits.length);
        int[] comparatorFields = new int[]{0};
        IBinaryComparatorFactory[] linearizerArray = new IBinaryComparatorFactory[]{linearizeCmpFactory};
        int[] bloomFilterKeyFields = new int[btreeCmpFactories.length];
        for (int i = 0; i < btreeCmpFactories.length; ++i) {
            bloomFilterKeyFields[i] = i;
        }
        BloomFilterFactory bloomFilterFactory = new BloomFilterFactory(diskBufferCache, bloomFilterKeyFields);
        LSMRTreeFileManager fileNameManager = new LSMRTreeFileManager(ioManager, file, diskRTreeFactory, (TreeIndexFactory<? extends ITreeIndex>)diskBTreeFactory);
        LSMRTreeDiskComponentFactory componentFactory = new LSMRTreeDiskComponentFactory(diskRTreeFactory, (TreeIndexFactory<BTree>)diskBTreeFactory, bloomFilterFactory, null);
        return new ExternalRTree(ioManager, (ITreeIndexFrameFactory)rtreeInteriorFrameFactory, (ITreeIndexFrameFactory)rtreeLeafFrameFactory, (ITreeIndexFrameFactory)btreeInteriorFrameFactory, (ITreeIndexFrameFactory)btreeLeafFrameFactory, diskBufferCache, (ILSMIndexFileManager)fileNameManager, componentFactory, bloomFilterFalsePositiveRate, typeTraits.length, rtreeCmpFactories, btreeCmpFactories, linearizeCmpFactory, comparatorFields, linearizerArray, mergePolicy, opTracker, ioScheduler, ioOpCallbackFactory, pageWriteCallbackFactory, buddyBTreeFields, durable, isPointMBR, tracer);
    }

    public static ILinearizeComparatorFactory proposeBestLinearizer(ITypeTraits[] typeTraits, int numKeyFields) throws HyracksDataException {
        for (int i = 0; i < numKeyFields; ++i) {
            if (typeTraits[i].getClass().equals(typeTraits[0].getClass())) continue;
            throw HyracksDataException.create((int)41, (Serializable[])new Serializable[0]);
        }
        if (numKeyFields / 2 == 2 && typeTraits[0].getClass() == DoublePointable.TYPE_TRAITS.getClass()) {
            return new HilbertDoubleComparatorFactory(2);
        }
        if (typeTraits[0].getClass() == DoublePointable.TYPE_TRAITS.getClass()) {
            return new ZCurveDoubleComparatorFactory(numKeyFields / 2);
        }
        if (typeTraits[0].getClass() == IntegerPointable.TYPE_TRAITS.getClass()) {
            return new ZCurveIntComparatorFactory(numKeyFields / 2);
        }
        throw HyracksDataException.create((int)42, (Serializable[])new Serializable[]{typeTraits[0].getClass().getSimpleName()});
    }
}

