/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.util.FeedLogManager;
import org.apache.asterix.external.util.LocalFileSystemUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileSystemWatcher {
    private static final Logger LOGGER = LogManager.getLogger();
    private WatchService watcher;
    private final HashMap<WatchKey, Path> keys;
    private final LinkedList<File> files = new LinkedList();
    private Iterator<File> it;
    private final String expression;
    private FeedLogManager logManager;
    private final List<Path> paths;
    private final boolean isFeed;
    private boolean done;
    private final LinkedList<Path> dirs;

    public FileSystemWatcher(List<Path> inputResources, String expression, boolean isFeed) throws HyracksDataException {
        this.isFeed = isFeed;
        this.keys = isFeed ? new HashMap() : null;
        this.expression = expression;
        this.paths = inputResources;
        this.dirs = new LinkedList();
        if (!isFeed) {
            this.init();
        }
    }

    public synchronized void setFeedLogManager(FeedLogManager feedLogManager) throws HyracksDataException {
        if (this.logManager == null) {
            this.logManager = feedLogManager;
            this.init();
        }
    }

    public synchronized void init() throws HyracksDataException {
        try {
            this.dirs.clear();
            for (Path path : this.paths) {
                LocalFileSystemUtils.traverse(this.files, path.toFile(), this.expression, this.dirs);
                this.it = this.files.iterator();
                if (this.isFeed) {
                    this.keys.clear();
                    if (this.watcher != null) {
                        try {
                            this.watcher.close();
                        }
                        catch (IOException e) {
                            LOGGER.warn("Failed to close watcher service", (Throwable)e);
                        }
                    }
                    this.watcher = FileSystems.getDefault().newWatchService();
                    for (Path dirPath : this.dirs) {
                        this.register(dirPath);
                    }
                    this.resume();
                    continue;
                }
                if (!this.files.isEmpty()) continue;
                throw new RuntimeDataException(3076, new Serializable[]{path.toString()});
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void register(Path dir) throws IOException {
        WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.keys.put(key, dir);
    }

    private synchronized void resume() throws IOException {
        if (this.logManager == null) {
            return;
        }
        if (this.it == null) {
            return;
        }
        while (this.it.hasNext()) {
            File file = this.it.next();
            if (!this.logManager.isSplitRead(file.getAbsolutePath())) continue;
            this.it.remove();
        }
        this.it = this.files.iterator();
    }

    static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    private synchronized void handleEvents(WatchKey key) throws IOException {
        Path dir = this.keys.get(key);
        if (dir == null) {
            LOGGER.warn("WatchKey not recognized!!");
            return;
        }
        for (WatchEvent<?> event : key.pollEvents()) {
            WatchEvent.Kind<?> kind = event.kind();
            if (kind == StandardWatchEventKinds.OVERFLOW) {
                LOGGER.warn("Overflow event. Some events might have been missed");
                this.init();
                return;
            }
            WatchEvent ev = FileSystemWatcher.cast(event);
            Path name = (Path)ev.context();
            Path child = dir.resolve(name);
            if (kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
            try {
                if (Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) {
                    this.register(child);
                    continue;
                }
                LocalFileSystemUtils.validateAndAdd(child, this.expression, this.files);
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        }
        this.it = this.files.iterator();
    }

    public synchronized void close() throws IOException {
        if (!this.done) {
            if (this.watcher != null) {
                this.watcher.close();
                this.watcher = null;
            }
            this.done = true;
        }
    }

    public synchronized File poll() throws IOException {
        if (this.it.hasNext()) {
            return this.it.next();
        }
        if (this.done || !this.isFeed) {
            return null;
        }
        this.files.clear();
        this.it = this.files.iterator();
        if (this.keys.isEmpty()) {
            this.close();
            return null;
        }
        WatchKey key = this.watcher.poll();
        while (key != null) {
            this.handleEvents(key);
            if (this.endOfEvents(key)) {
                this.close();
                return null;
            }
            key = this.watcher.poll();
        }
        return null;
    }

    public File take() throws IOException {
        File next = this.poll();
        if (next != null) {
            return next;
        }
        if (this.done || !this.isFeed) {
            return null;
        }
        while (!this.it.hasNext()) {
            WatchKey key;
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException x) {
                LOGGER.warn("Feed Closed");
                if (this.watcher != null) continue;
                return null;
            }
            catch (ClosedWatchServiceException e) {
                LOGGER.warn("The watcher has exited");
                if (this.watcher != null) continue;
                return null;
            }
            this.handleEvents(key);
            if (!this.endOfEvents(key)) continue;
            return null;
        }
        return this.it.next();
    }

    private boolean endOfEvents(WatchKey key) {
        if (!key.reset()) {
            this.keys.remove(key);
            if (this.keys.isEmpty()) {
                return true;
            }
        }
        return false;
    }
}

