/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.io;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameReader;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IFileHandle;
import org.apache.hyracks.api.io.IIOManager;

public class RunFileReader
implements IFrameReader {
    private final FileReference file;
    private IFileHandle handle;
    private final IIOManager ioManager;
    private final long size;
    private long readPtr;
    private boolean deleteAfterClose;

    public RunFileReader(FileReference file, IIOManager ioManager, long size, boolean deleteAfterRead) {
        this.file = file;
        this.ioManager = ioManager;
        this.size = size;
        this.deleteAfterClose = deleteAfterRead;
    }

    public void open() throws HyracksDataException {
        this.handle = this.ioManager.open(this.file, IIOManager.FileReadWriteMode.READ_ONLY, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
        this.readPtr = 0L;
    }

    public void seek(long position) {
        if (position < 0L) {
            throw new IllegalArgumentException(String.valueOf(position));
        }
        this.readPtr = position;
    }

    public long position() {
        return this.readPtr;
    }

    public boolean nextFrame(IFrame frame) throws HyracksDataException {
        if (this.readPtr >= this.size) {
            return false;
        }
        frame.reset();
        int readLength = this.ioManager.syncRead(this.handle, this.readPtr, frame.getBuffer());
        if (readLength <= 0) {
            throw HyracksDataException.create((int)120, (Serializable[])new Serializable[0]);
        }
        this.readPtr += (long)readLength;
        frame.ensureFrameSize(frame.getMinSize() * FrameHelper.deserializeNumOfMinFrame((ByteBuffer)frame.getBuffer()));
        if (frame.getBuffer().hasRemaining()) {
            if (this.readPtr < this.size) {
                readLength = this.ioManager.syncRead(this.handle, this.readPtr, frame.getBuffer());
                if (readLength < 0) {
                    throw HyracksDataException.create((int)120, (Serializable[])new Serializable[0]);
                }
                this.readPtr += (long)readLength;
            }
            if (frame.getBuffer().hasRemaining()) {
                FrameHelper.clearRemainingFrame((ByteBuffer)frame.getBuffer(), (int)frame.getBuffer().position());
            }
        }
        frame.getBuffer().flip();
        return true;
    }

    public void close() throws HyracksDataException {
        if (this.handle == null) {
            return;
        }
        if (this.deleteAfterClose) {
            try {
                this.ioManager.close(this.handle);
                FileUtils.deleteQuietly((File)this.file.getFile());
            }
            catch (IOException e) {
                throw HyracksDataException.create((int)19, (Throwable)e, (Serializable[])new Serializable[]{this.file.toString()});
            }
        } else {
            this.ioManager.close(this.handle);
        }
        this.handle = null;
    }

    public long getFileSize() {
        return this.size;
    }

    public void setDeleteAfterClose(boolean deleteAfterClose) {
        this.deleteAfterClose = deleteAfterClose;
    }
}

