/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.comm.util;

import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buffer;
    private int position;

    public void setByteBuffer(ByteBuffer buffer, int position) {
        this.buffer = buffer;
        this.position = position;
    }

    @Override
    public int read() {
        int remaining = this.buffer.capacity() - this.position;
        int value = remaining > 0 ? this.buffer.array()[this.position++] & 0xFF : -1;
        return value;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) {
        int remaining = this.buffer.capacity() - this.position;
        if (remaining == 0) {
            return -1;
        }
        int l = Math.min(length, remaining);
        System.arraycopy(this.buffer.array(), this.position, bytes, offset, l);
        this.position += l;
        return l;
    }
}

