/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.booleans;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.booleans.BooleanBigArrays;
import it.unimi.dsi.fastutil.booleans.BooleanComparator;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;

public final class BooleanBigArrays {
    public static final boolean[][] EMPTY_BIG_ARRAY = new boolean[0][];
    public static final boolean[][] DEFAULT_EMPTY_BIG_ARRAY = new boolean[0][];
    public static final Hash.Strategy HASH_STRATEGY = new BigArrayHashStrategy(null);
    private static final int QUICKSORT_NO_REC = 7;
    private static final int PARALLEL_QUICKSORT_NO_FORK = 8192;
    private static final int MEDIUM = 40;

    private BooleanBigArrays() {
    }

    @Deprecated
    public static boolean get(boolean[][] array, long index) {
        return array[BigArrays.segment((long)index)][BigArrays.displacement((long)index)];
    }

    @Deprecated
    public static void set(boolean[][] array, long index, boolean value) {
        array[BigArrays.segment((long)index)][BigArrays.displacement((long)index)] = value;
    }

    @Deprecated
    public static void swap(boolean[][] array, long first, long second) {
        boolean t = array[BigArrays.segment((long)first)][BigArrays.displacement((long)first)];
        array[BigArrays.segment((long)first)][BigArrays.displacement((long)first)] = array[BigArrays.segment((long)second)][BigArrays.displacement((long)second)];
        array[BigArrays.segment((long)second)][BigArrays.displacement((long)second)] = t;
    }

    @Deprecated
    public static long length(boolean[][] array) {
        int length = array.length;
        return length == 0 ? 0L : BigArrays.start((int)(length - 1)) + (long)array[length - 1].length;
    }

    @Deprecated
    public static void copy(boolean[][] srcArray, long srcPos, boolean[][] destArray, long destPos, long length) {
        BigArrays.copy((boolean[][])srcArray, (long)srcPos, (boolean[][])destArray, (long)destPos, (long)length);
    }

    @Deprecated
    public static void copyFromBig(boolean[][] srcArray, long srcPos, boolean[] destArray, int destPos, int length) {
        BigArrays.copyFromBig((boolean[][])srcArray, (long)srcPos, (boolean[])destArray, (int)destPos, (int)length);
    }

    @Deprecated
    public static void copyToBig(boolean[] srcArray, int srcPos, boolean[][] destArray, long destPos, long length) {
        BigArrays.copyToBig((boolean[])srcArray, (int)srcPos, (boolean[][])destArray, (long)destPos, (long)length);
    }

    public static boolean[][] newBigArray(long length) {
        if (length == 0L) {
            return EMPTY_BIG_ARRAY;
        }
        BigArrays.ensureLength((long)length);
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        boolean[][] base = new boolean[baseLength][];
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            for (int i = 0; i < baseLength - 1; ++i) {
                base[i] = new boolean[0x8000000];
            }
            base[baseLength - 1] = new boolean[residual];
        } else {
            for (int i = 0; i < baseLength; ++i) {
                base[i] = new boolean[0x8000000];
            }
        }
        return base;
    }

    @Deprecated
    public static boolean[][] wrap(boolean[] array) {
        return BigArrays.wrap((boolean[])array);
    }

    @Deprecated
    public static boolean[][] ensureCapacity(boolean[][] array, long length) {
        return BooleanBigArrays.ensureCapacity(array, length, BooleanBigArrays.length(array));
    }

    @Deprecated
    public static boolean[][] forceCapacity(boolean[][] array, long length, long preserve) {
        return BigArrays.forceCapacity((boolean[][])array, (long)length, (long)preserve);
    }

    @Deprecated
    public static boolean[][] ensureCapacity(boolean[][] array, long length, long preserve) {
        return length > BooleanBigArrays.length(array) ? BooleanBigArrays.forceCapacity(array, length, preserve) : array;
    }

    @Deprecated
    public static boolean[][] grow(boolean[][] array, long length) {
        long oldLength = BooleanBigArrays.length(array);
        return length > oldLength ? BooleanBigArrays.grow(array, length, oldLength) : array;
    }

    @Deprecated
    public static boolean[][] grow(boolean[][] array, long length, long preserve) {
        long oldLength = BooleanBigArrays.length(array);
        return length > oldLength ? BooleanBigArrays.ensureCapacity(array, Math.max(oldLength + (oldLength >> 1), length), preserve) : array;
    }

    @Deprecated
    public static boolean[][] trim(boolean[][] array, long length) {
        BigArrays.ensureLength((long)length);
        long oldLength = BooleanBigArrays.length(array);
        if (length >= oldLength) {
            return array;
        }
        int baseLength = (int)(length + 0x7FFFFFFL >>> 27);
        boolean[][] base = (boolean[][])Arrays.copyOf(array, baseLength);
        int residual = (int)(length & 0x7FFFFFFL);
        if (residual != 0) {
            base[baseLength - 1] = BooleanArrays.trim(base[baseLength - 1], residual);
        }
        return base;
    }

    @Deprecated
    public static boolean[][] setLength(boolean[][] array, long length) {
        return BigArrays.setLength((boolean[][])array, (long)length);
    }

    @Deprecated
    public static boolean[][] copy(boolean[][] array, long offset, long length) {
        return BigArrays.copy((boolean[][])array, (long)offset, (long)length);
    }

    @Deprecated
    public static boolean[][] copy(boolean[][] array) {
        return BigArrays.copy((boolean[][])array);
    }

    @Deprecated
    public static void fill(boolean[][] array, boolean value) {
        int i = array.length;
        while (i-- != 0) {
            Arrays.fill(array[i], value);
        }
    }

    @Deprecated
    public static void fill(boolean[][] array, long from, long to, boolean value) {
        BigArrays.fill((boolean[][])array, (long)from, (long)to, (boolean)value);
    }

    @Deprecated
    public static boolean equals(boolean[][] a1, boolean[][] a2) {
        return BigArrays.equals((boolean[][])a1, (boolean[][])a2);
    }

    @Deprecated
    public static String toString(boolean[][] a) {
        return BigArrays.toString((boolean[][])a);
    }

    @Deprecated
    public static void ensureFromTo(boolean[][] a, long from, long to) {
        BigArrays.ensureFromTo((long)BooleanBigArrays.length(a), (long)from, (long)to);
    }

    @Deprecated
    public static void ensureOffsetLength(boolean[][] a, long offset, long length) {
        BigArrays.ensureOffsetLength((long)BooleanBigArrays.length(a), (long)offset, (long)length);
    }

    @Deprecated
    public static void ensureSameLength(boolean[][] a, boolean[][] b) {
        if (BooleanBigArrays.length(a) != BooleanBigArrays.length(b)) {
            throw new IllegalArgumentException("Array size mismatch: " + BooleanBigArrays.length(a) + " != " + BooleanBigArrays.length(b));
        }
    }

    private static ForkJoinPool getPool() {
        ForkJoinPool current = ForkJoinTask.getPool();
        return current == null ? ForkJoinPool.commonPool() : current;
    }

    private static void swap(boolean[][] x, long a, long b, long n) {
        int i = 0;
        while ((long)i < n) {
            BigArrays.swap((boolean[][])x, (long)a, (long)b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static long med3(boolean[][] x, long a, long b, long c, BooleanComparator comp) {
        int ab = comp.compare(BigArrays.get((boolean[][])x, (long)a), BigArrays.get((boolean[][])x, (long)b));
        int ac = comp.compare(BigArrays.get((boolean[][])x, (long)a), BigArrays.get((boolean[][])x, (long)c));
        int bc = comp.compare(BigArrays.get((boolean[][])x, (long)b), BigArrays.get((boolean[][])x, (long)c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(boolean[][] a, long from, long to, BooleanComparator comp) {
        for (long i = from; i < to - 1L; ++i) {
            long m = i;
            for (long j = i + 1L; j < to; ++j) {
                if (comp.compare(BigArrays.get((boolean[][])a, (long)j), BigArrays.get((boolean[][])a, (long)m)) >= 0) continue;
                m = j;
            }
            if (m == i) continue;
            BigArrays.swap((boolean[][])a, (long)i, (long)m);
        }
    }

    public static void quickSort(boolean[][] x, long from, long to, BooleanComparator comp) {
        long c;
        long a;
        long len = to - from;
        if (len < 7L) {
            BooleanBigArrays.selectionSort(x, from, to, comp);
            return;
        }
        long m = from + len / 2L;
        if (len > 7L) {
            long l = from;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = BooleanBigArrays.med3(x, l, l + s, l + 2L * s, comp);
                m = BooleanBigArrays.med3(x, m - s, m, m + s, comp);
                n = BooleanBigArrays.med3(x, n - 2L * s, n - s, n, comp);
            }
            m = BooleanBigArrays.med3(x, l, m, n, comp);
        }
        boolean v = BigArrays.get((boolean[][])x, (long)m);
        long b = a = from;
        long d = c = to - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(BigArrays.get((boolean[][])x, (long)b), v)) <= 0) {
                if (comparison == 0) {
                    BigArrays.swap((boolean[][])x, (long)a++, (long)b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(BigArrays.get((boolean[][])x, (long)c), v)) >= 0) {
                if (comparison == 0) {
                    BigArrays.swap((boolean[][])x, (long)c, (long)d--);
                }
                --c;
            }
            if (b > c) break;
            BigArrays.swap((boolean[][])x, (long)b++, (long)c--);
        }
        long n = to;
        long s = Math.min(a - from, b - a);
        BooleanBigArrays.swap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1L);
        BooleanBigArrays.swap(x, b, n - s, s);
        s = b - a;
        if (s > 1L) {
            BooleanBigArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1L) {
            BooleanBigArrays.quickSort(x, n - s, n, comp);
        }
    }

    private static long med3(boolean[][] x, long a, long b, long c) {
        int ab = Boolean.compare(BigArrays.get((boolean[][])x, (long)a), BigArrays.get((boolean[][])x, (long)b));
        int ac = Boolean.compare(BigArrays.get((boolean[][])x, (long)a), BigArrays.get((boolean[][])x, (long)c));
        int bc = Boolean.compare(BigArrays.get((boolean[][])x, (long)b), BigArrays.get((boolean[][])x, (long)c));
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    private static void selectionSort(boolean[][] a, long from, long to) {
        for (long i = from; i < to - 1L; ++i) {
            long m = i;
            for (long j = i + 1L; j < to; ++j) {
                if (BigArrays.get((boolean[][])a, (long)j) || !BigArrays.get((boolean[][])a, (long)m)) continue;
                m = j;
            }
            if (m == i) continue;
            BigArrays.swap((boolean[][])a, (long)i, (long)m);
        }
    }

    public static void quickSort(boolean[][] x, BooleanComparator comp) {
        BooleanBigArrays.quickSort(x, 0L, BigArrays.length((boolean[][])x), comp);
    }

    public static void quickSort(boolean[][] x, long from, long to) {
        long c;
        long a;
        long len = to - from;
        if (len < 7L) {
            BooleanBigArrays.selectionSort(x, from, to);
            return;
        }
        long m = from + len / 2L;
        if (len > 7L) {
            long l = from;
            long n = to - 1L;
            if (len > 40L) {
                long s = len / 8L;
                l = BooleanBigArrays.med3(x, l, l + s, l + 2L * s);
                m = BooleanBigArrays.med3(x, m - s, m, m + s);
                n = BooleanBigArrays.med3(x, n - 2L * s, n - s, n);
            }
            m = BooleanBigArrays.med3(x, l, m, n);
        }
        boolean v = BigArrays.get((boolean[][])x, (long)m);
        long b = a = from;
        long d = c = to - 1L;
        while (true) {
            int comparison;
            if (b <= c && (comparison = Boolean.compare(BigArrays.get((boolean[][])x, (long)b), v)) <= 0) {
                if (comparison == 0) {
                    BigArrays.swap((boolean[][])x, (long)a++, (long)b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = Boolean.compare(BigArrays.get((boolean[][])x, (long)c), v)) >= 0) {
                if (comparison == 0) {
                    BigArrays.swap((boolean[][])x, (long)c, (long)d--);
                }
                --c;
            }
            if (b > c) break;
            BigArrays.swap((boolean[][])x, (long)b++, (long)c--);
        }
        long n = to;
        long s = Math.min(a - from, b - a);
        BooleanBigArrays.swap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1L);
        BooleanBigArrays.swap(x, b, n - s, s);
        s = b - a;
        if (s > 1L) {
            BooleanBigArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1L) {
            BooleanBigArrays.quickSort(x, n - s, n);
        }
    }

    public static void quickSort(boolean[][] x) {
        BooleanBigArrays.quickSort(x, 0L, BigArrays.length((boolean[][])x));
    }

    public static void parallelQuickSort(boolean[][] x, long from, long to) {
        ForkJoinPool pool = BooleanBigArrays.getPool();
        if (to - from < 8192L || pool.getParallelism() == 1) {
            BooleanBigArrays.quickSort(x, from, to);
        } else {
            pool.invoke(new ForkJoinQuickSort(x, from, to));
        }
    }

    public static void parallelQuickSort(boolean[][] x) {
        BooleanBigArrays.parallelQuickSort(x, 0L, BigArrays.length((boolean[][])x));
    }

    public static void parallelQuickSort(boolean[][] x, long from, long to, BooleanComparator comp) {
        ForkJoinPool pool = BooleanBigArrays.getPool();
        if (to - from < 8192L || pool.getParallelism() == 1) {
            BooleanBigArrays.quickSort(x, from, to, comp);
        } else {
            pool.invoke(new ForkJoinQuickSortComp(x, from, to, comp));
        }
    }

    public static void parallelQuickSort(boolean[][] x, BooleanComparator comp) {
        BooleanBigArrays.parallelQuickSort(x, 0L, BigArrays.length((boolean[][])x), comp);
    }

    public static boolean[][] shuffle(boolean[][] a, long from, long to, Random random) {
        return BigArrays.shuffle((boolean[][])a, (long)from, (long)to, (Random)random);
    }

    public static boolean[][] shuffle(boolean[][] a, Random random) {
        return BigArrays.shuffle((boolean[][])a, (Random)random);
    }

    static /* synthetic */ long access$100(boolean[][] x0, long x1, long x2, long x3) {
        return BooleanBigArrays.med3(x0, x1, x2, x3);
    }

    static /* synthetic */ void access$200(boolean[][] x0, long x1, long x2, long x3) {
        BooleanBigArrays.swap(x0, x1, x2, x3);
    }

    static /* synthetic */ long access$300(boolean[][] x0, long x1, long x2, long x3, BooleanComparator x4) {
        return BooleanBigArrays.med3(x0, x1, x2, x3, x4);
    }
}

