/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.algebricks.core.algebra.metadata.IProjectionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;

public class ExternalDataProjectionInfo
implements IProjectionInfo<List<String>> {
    private final List<List<String>> projectedFieldNames = new ArrayList<List<String>>();

    public ExternalDataProjectionInfo() {
    }

    private ExternalDataProjectionInfo(List<List<String>> projectedFieldNames) {
        for (List<String> path : projectedFieldNames) {
            ArrayList<String> newPath = new ArrayList<String>(path);
            this.projectedFieldNames.add(newPath);
        }
    }

    public List<List<String>> getProjectionInfo() {
        return this.projectedFieldNames;
    }

    public IProjectionInfo<List<String>> createCopy() {
        return new ExternalDataProjectionInfo(this.projectedFieldNames);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ExternalDataProjectionInfo)) {
            return false;
        }
        List<List<String>> otherProjectedFieldNames = ((ExternalDataProjectionInfo)other).projectedFieldNames;
        return this.projectedFieldNames.size() == otherProjectedFieldNames.size() && VariableUtilities.varListEqualUnordered(this.projectedFieldNames, otherProjectedFieldNames);
    }

    public String toString() {
        if (this.projectedFieldNames.isEmpty()) {
            return "";
        }
        StringBuilder fieldNamesBuilder = new StringBuilder();
        this.append(fieldNamesBuilder);
        return fieldNamesBuilder.toString();
    }

    public void addToProperties(Map<String, String> properties) {
        String pushedFieldNames = this.toString();
        if (!pushedFieldNames.isEmpty()) {
            properties.put("requested-fields", this.toString());
        }
    }

    private void append(StringBuilder builder) {
        this.appendFieldNames(this.projectedFieldNames.get(0), builder);
        for (int i = 1; i < this.projectedFieldNames.size(); ++i) {
            builder.append(", ");
            this.appendFieldNames(this.projectedFieldNames.get(i), builder);
        }
    }

    private void appendFieldNames(List<String> fieldNames, StringBuilder builder) {
        builder.append(fieldNames.get(0));
        for (int i = 1; i < fieldNames.size(); ++i) {
            builder.append('.').append(fieldNames.get(i));
        }
    }
}

