/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.distribution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.teradata.tpcds.distribution.DistributionUtils;
import com.teradata.tpcds.random.RandomNumberStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StringValuesDistribution {
    private final ImmutableList<ImmutableList<String>> valuesLists;
    private final ImmutableList<ImmutableList<Integer>> weightsLists;

    public StringValuesDistribution(ImmutableList<ImmutableList<String>> valuesLists, ImmutableList<ImmutableList<Integer>> weightsLists) {
        this.valuesLists = valuesLists;
        this.weightsLists = weightsLists;
    }

    public static StringValuesDistribution buildStringValuesDistribution(String valuesAndWeightsFilename, int numValueFields, int numWeightFields) {
        Iterator<List<String>> iterator = DistributionUtils.getDistributionIterator(valuesAndWeightsFilename);
        ArrayList<ImmutableList.Builder> valuesBuilders = new ArrayList<ImmutableList.Builder>(numValueFields);
        for (int i = 0; i < numValueFields; ++i) {
            valuesBuilders.add(ImmutableList.builder());
        }
        ArrayList<DistributionUtils.WeightsBuilder> weightsBuilders = new ArrayList<DistributionUtils.WeightsBuilder>(numWeightFields);
        for (int i = 0; i < numWeightFields; ++i) {
            weightsBuilders.add(new DistributionUtils.WeightsBuilder());
        }
        while (iterator.hasNext()) {
            List<String> fields = iterator.next();
            Preconditions.checkState((fields.size() == 2 ? 1 : 0) != 0, (String)"Expected line to contain 2 parts but it contains %s: %s", (Object[])new Object[]{fields.size(), fields});
            List<String> values = DistributionUtils.getListFromCommaSeparatedValues(fields.get(0));
            Preconditions.checkState((values.size() == numValueFields ? 1 : 0) != 0, (String)"Expected line to contain %s values, but it contained %s, %s", (Object[])new Object[]{numValueFields, values.size(), values});
            for (int i = 0; i < values.size(); ++i) {
                ((ImmutableList.Builder)valuesBuilders.get(i)).add(values.get(i));
            }
            List<String> weights = DistributionUtils.getListFromCommaSeparatedValues(fields.get(1));
            Preconditions.checkState((weights.size() == numWeightFields ? 1 : 0) != 0, (String)"Expected line to contain %s weights, but it contained %s, %s", (Object[])new Object[]{numWeightFields, weights.size(), weights});
            for (int i = 0; i < weights.size(); ++i) {
                ((DistributionUtils.WeightsBuilder)weightsBuilders.get(i)).computeAndAddNextWeight(Integer.parseInt(weights.get(i)));
            }
        }
        ImmutableList.Builder valuesListsBuilder = ImmutableList.builder();
        for (ImmutableList.Builder valuesBuilder : valuesBuilders) {
            valuesListsBuilder.add((Object)valuesBuilder.build());
        }
        ImmutableList valuesLists = valuesListsBuilder.build();
        ImmutableList.Builder weightsListBuilder = ImmutableList.builder();
        for (DistributionUtils.WeightsBuilder weightsBuilder : weightsBuilders) {
            weightsListBuilder.add(weightsBuilder.build());
        }
        ImmutableList weightsLists = weightsListBuilder.build();
        return new StringValuesDistribution((ImmutableList<ImmutableList<String>>)valuesLists, (ImmutableList<ImmutableList<Integer>>)weightsLists);
    }

    public String pickRandomValue(int valueListIndex, int weightListIndex, RandomNumberStream stream) {
        Preconditions.checkArgument((valueListIndex < this.valuesLists.size() ? 1 : 0) != 0, (Object)("index out of range, max value index is " + (this.valuesLists.size() - 1)));
        Preconditions.checkArgument((weightListIndex < this.weightsLists.size() ? 1 : 0) != 0, (Object)("index out of range, max weight index is " + (this.weightsLists.size() - 1)));
        return (String)DistributionUtils.pickRandomValue((List)this.valuesLists.get(valueListIndex), (List)this.weightsLists.get(weightListIndex), stream);
    }

    public String getValueForIndexModSize(long index, int valueListIndex) {
        Preconditions.checkArgument((valueListIndex < this.valuesLists.size() ? 1 : 0) != 0, (Object)("index out of range, max value index is " + (this.valuesLists.size() - 1)));
        return (String)DistributionUtils.getValueForIndexModSize(index, (List)this.valuesLists.get(valueListIndex));
    }

    public int pickRandomIndex(int weightListIndex, RandomNumberStream stream) {
        Preconditions.checkArgument((weightListIndex < this.weightsLists.size() ? 1 : 0) != 0, (Object)("index out of range, max weight index is " + (this.weightsLists.size() - 1)));
        return DistributionUtils.pickRandomIndex((List)this.weightsLists.get(weightListIndex), stream);
    }

    public int getWeightForIndex(int index, int weightListIndex) {
        Preconditions.checkArgument((weightListIndex < this.weightsLists.size() ? 1 : 0) != 0, (Object)("index out of range, max weight index is " + (this.weightsLists.size() - 1)));
        return DistributionUtils.getWeightForIndex(index, (List)this.weightsLists.get(weightListIndex));
    }

    public int getSize() {
        return ((ImmutableList)this.valuesLists.get(0)).size();
    }

    public String getValueAtIndex(int valueListIndex, int valueIndex) {
        return (String)((ImmutableList)this.valuesLists.get(valueListIndex)).get(valueIndex);
    }
}

