/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.util;

import org.apache.hadoop.conf.Configuration;

public final class MRJobConfUtil {
    public static final String REDACTION_REPLACEMENT_VAL = "*********(redacted)";
    public static final float TASK_REPORT_INTERVAL_TO_TIMEOUT_RATIO = 0.01f;

    public static void redact(Configuration conf) {
        for (String prop : conf.getTrimmedStringCollection("mapreduce.job.redacted-properties")) {
            conf.set(prop, REDACTION_REPLACEMENT_VAL);
        }
    }

    private MRJobConfUtil() {
    }

    public static long getTaskProgressReportInterval(Configuration conf) {
        long taskHeartbeatTimeOut = conf.getLong("mapreduce.task.timeout", 300000L);
        return conf.getLong("mapreduce.task.progress-report.interval", (long)(0.01f * (float)taskHeartbeatTimeOut));
    }
}

