/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.jets3t.service.Constants;

public class AWSDevPayProduct
implements Serializable,
Comparable {
    private static final long serialVersionUID = 7581378683354747125L;
    private String productName = null;
    private String productToken = null;

    public AWSDevPayProduct(String productToken) {
        this.productToken = productToken;
    }

    public AWSDevPayProduct(String productToken, String productName) {
        this(productToken);
        this.productName = productName;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductToken() {
        return this.productToken;
    }

    public String toString() {
        return this.getProductName();
    }

    public int compareTo(Object o) {
        return this.getProductName().compareTo(((AWSDevPayProduct)o).getProductName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector load() throws IOException {
        InputStream pin = AWSDevPayProduct.class.getResourceAsStream("/" + Constants.DEVPAY_PRODUCTS_PROPERTIES_FILENAME);
        Vector ret = new Vector();
        if (pin != null) {
            try {
                ret = AWSDevPayProduct.load(pin);
            }
            finally {
                pin.close();
            }
        }
        return ret;
    }

    public static Vector load(InputStream pin) throws IOException {
        if (pin == null) {
            return new Vector();
        }
        Properties prodProps = new Properties();
        prodProps.load(pin);
        return AWSDevPayProduct.load(prodProps);
    }

    public static Vector load(Properties prodProps) {
        Vector<AWSDevPayProduct> ret = new Vector<AWSDevPayProduct>();
        Enumeration<?> propEnum = prodProps.propertyNames();
        while (propEnum.hasMoreElements()) {
            String propName = (String)propEnum.nextElement();
            if (!propName.endsWith(Constants.DEVPAY_PRODUCT_NAME_PROP_SUFFIX)) continue;
            String tokenPropName = propName.substring(0, propName.length() - Constants.DEVPAY_PRODUCT_NAME_PROP_SUFFIX.length()) + Constants.DEVPAY_PRODUCT_TOKEN_PROP_SUFFIX;
            String prodName = prodProps.getProperty(propName);
            String prodToken = prodProps.getProperty(tokenPropName);
            if (prodToken == null) continue;
            ret.add(new AWSDevPayProduct(prodToken, prodName));
        }
        Collections.sort(ret);
        return ret;
    }
}

