/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWECryptoParts;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.crypto.AESKW;
import com.nimbusds.jose.crypto.ContentCryptoProvider;
import com.nimbusds.jose.crypto.ECDH;
import com.nimbusds.jose.crypto.ECDHCryptoProvider;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.util.Base64URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import javax.crypto.SecretKey;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ECDHEncrypter
extends ECDHCryptoProvider
implements JWEEncrypter {
    private final ECPublicKey publicKey;

    public ECDHEncrypter(ECPublicKey publicKey) throws JOSEException {
        super(ECKey.Curve.forECParameterSpec(publicKey.getParams()));
        this.publicKey = publicKey;
    }

    public ECDHEncrypter(ECKey ecJWK) throws JOSEException {
        super(ecJWK.getCurve());
        this.publicKey = ecJWK.toECPublicKey();
    }

    public ECPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText) throws JOSEException {
        Base64URL encryptedKey;
        SecretKey cek;
        JWEAlgorithm alg = header.getAlgorithm();
        ECDH.AlgorithmMode algMode = ECDH.resolveAlgorithmMode(alg);
        EncryptionMethod enc = header.getEncryptionMethod();
        KeyPair ephemeralKeyPair = this.generateEphemeralKeyPair(this.publicKey.getParams());
        ECPublicKey ephemeralPublicKey = (ECPublicKey)ephemeralKeyPair.getPublic();
        ECPrivateKey ephemeralPrivateKey = (ECPrivateKey)ephemeralKeyPair.getPrivate();
        SecretKey Z = ECDH.deriveSharedSecret(this.publicKey, ephemeralPrivateKey, this.getJCAContext().getKeyEncryptionProvider());
        this.getConcatKDF().getJCAContext().setProvider(this.getJCAContext().getMACProvider());
        SecretKey sharedKey = ECDH.deriveSharedKey(header, Z, this.getConcatKDF());
        if (algMode.equals((Object)ECDH.AlgorithmMode.DIRECT)) {
            cek = sharedKey;
            encryptedKey = null;
        } else if (algMode.equals((Object)ECDH.AlgorithmMode.KW)) {
            cek = ContentCryptoProvider.generateCEK(enc, this.getJCAContext().getSecureRandom());
            encryptedKey = Base64URL.encode(AESKW.wrapCEK(cek, sharedKey, this.getJCAContext().getKeyEncryptionProvider()));
        } else {
            throw new JOSEException("Unexpected JWE ECDH algorithm mode: " + (Object)((Object)algMode));
        }
        JWEHeader updatedHeader = new JWEHeader.Builder(header).ephemeralPublicKey(new ECKey.Builder(this.getCurve(), ephemeralPublicKey).build()).build();
        return ContentCryptoProvider.encrypt(updatedHeader, clearText, cek, encryptedKey, this.getJCAContext());
    }

    private KeyPair generateEphemeralKeyPair(ECParameterSpec ecParameterSpec) throws JOSEException {
        Provider keProvider = this.getJCAContext().getKeyEncryptionProvider();
        try {
            KeyPairGenerator generator = keProvider != null ? KeyPairGenerator.getInstance("EC", keProvider) : KeyPairGenerator.getInstance("EC");
            generator.initialize(ecParameterSpec);
            return generator.generateKeyPair();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new JOSEException("Couldn't generate ephemeral EC key pair: " + e.getMessage(), e);
        }
    }
}

