/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.buffermanager;

import java.util.BitSet;
import java.util.function.IntUnaryOperator;
import org.apache.hyracks.dataflow.std.buffermanager.IPartitionedMemoryConstrain;
import org.apache.hyracks.dataflow.std.buffermanager.IPartitionedTupleBufferManager;

public class PreferToSpillFullyOccupiedFramePolicy {
    private final IPartitionedTupleBufferManager bufferManager;
    private final BitSet spilledStatus;

    public PreferToSpillFullyOccupiedFramePolicy(IPartitionedTupleBufferManager bufferManager, BitSet spilledStatus) {
        this.bufferManager = bufferManager;
        this.spilledStatus = spilledStatus;
    }

    public int selectVictimPartition(int failedToInsertPartition) {
        if (this.bufferManager.getNumTuples(failedToInsertPartition) > 0) {
            return failedToInsertPartition;
        }
        return this.findInMemPartitionWithMaxMemoryUsage();
    }

    public int findInMemPartitionWithMaxMemoryUsage() {
        return this.findMaxSize(this.spilledStatus.nextClearBit(0), i -> this.spilledStatus.nextClearBit(i + 1));
    }

    public int findSpilledPartitionWithMaxMemoryUsage() {
        return this.findMaxSize(this.spilledStatus.nextSetBit(0), i -> this.spilledStatus.nextSetBit(i + 1));
    }

    private int findMaxSize(int startIndex, IntUnaryOperator nextIndexOp) {
        int pid = -1;
        int max = 0;
        int i = startIndex;
        while (i >= 0 && i < this.bufferManager.getNumPartitions()) {
            int partSize = this.bufferManager.getPhysicalSize(i);
            if (partSize > max) {
                max = partSize;
                pid = i;
            }
            i = nextIndexOp.applyAsInt(i);
        }
        return pid;
    }

    public static IPartitionedMemoryConstrain createAtMostOneFrameForSpilledPartitionConstrain(final BitSet spillStatus) {
        return new IPartitionedMemoryConstrain(){

            @Override
            public int frameLimit(int partitionId) {
                if (spillStatus.get(partitionId)) {
                    return 1;
                }
                return Integer.MAX_VALUE;
            }
        };
    }
}

