/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.temporal;

import java.io.DataOutput;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADayTimeDurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ATimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AYearMonthDurationSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInterval;
import org.apache.asterix.om.base.AMutableInterval;
import org.apache.asterix.om.base.temporal.DurationArithmeticOperations;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.IncompatibleTypeException;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.OverflowException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.asterix.runtime.exceptions.UnderflowException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class IntervalBinDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new IntervalBinDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final DataOutput out = this.resultStorage.getDataOutput();
                    private final IPointable argPtr0 = new VoidPointable();
                    private final IPointable argPtr1 = new VoidPointable();
                    private final IPointable argPtr2 = new VoidPointable();
                    private final IScalarEvaluator eval0;
                    private final IScalarEvaluator eval1;
                    private final IScalarEvaluator eval2;
                    private final AMutableInterval aInterval;
                    private final ISerializerDeserializer<AInterval> intervalSerde;
                    private final GregorianCalendarSystem GREG_CAL;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.eval1 = args[1].createScalarEvaluator(ctx);
                        this.eval2 = args[2].createScalarEvaluator(ctx);
                        this.aInterval = new AMutableInterval(0L, 0L, -1);
                        this.intervalSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINTERVAL);
                        this.GREG_CAL = GregorianCalendarSystem.getInstance();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        long binEndChronon;
                        long binStartChronon;
                        long binIndex;
                        this.resultStorage.reset();
                        this.eval0.evaluate(tuple, this.argPtr0);
                        this.eval1.evaluate(tuple, this.argPtr1);
                        this.eval2.evaluate(tuple, this.argPtr2);
                        if (PointableHelper.checkAndSetMissingOrNull(result, this.argPtr0, this.argPtr1, this.argPtr2)) {
                            return;
                        }
                        byte[] bytes0 = this.argPtr0.getByteArray();
                        int offset0 = this.argPtr0.getStartOffset();
                        ATypeTag type0 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes0[offset0]);
                        long chrononToBin = 0L;
                        switch (type0) {
                            case DATE: {
                                chrononToBin = (long)ADateSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1)) * 86400000L;
                                break;
                            }
                            case TIME: {
                                chrononToBin = ATimeSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
                                break;
                            }
                            case DATETIME: {
                                chrononToBin = ADateTimeSerializerDeserializer.getChronon((byte[])bytes0, (int)(offset0 + 1));
                                break;
                            }
                            default: {
                                throw new TypeMismatchException(IntervalBinDescriptor.this.sourceLoc, IntervalBinDescriptor.this.getIdentifier(), 0, bytes0[offset0], ATypeTag.SERIALIZED_DATE_TYPE_TAG, ATypeTag.SERIALIZED_TIME_TYPE_TAG, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
                            }
                        }
                        byte[] bytes1 = this.argPtr1.getByteArray();
                        int offset1 = this.argPtr1.getStartOffset();
                        ATypeTag type1 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes1[offset1]);
                        if (type0 != type1) {
                            throw new IncompatibleTypeException(IntervalBinDescriptor.this.sourceLoc, IntervalBinDescriptor.this.getIdentifier(), bytes0[offset0], bytes1[offset1]);
                        }
                        long chrononToStart = 0L;
                        switch (type1) {
                            case DATE: {
                                chrononToStart = (long)ADateSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1)) * 86400000L;
                                break;
                            }
                            case TIME: {
                                chrononToStart = ATimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                                break;
                            }
                            case DATETIME: {
                                chrononToStart = ADateTimeSerializerDeserializer.getChronon((byte[])bytes1, (int)(offset1 + 1));
                                break;
                            }
                            default: {
                                throw new TypeMismatchException(IntervalBinDescriptor.this.sourceLoc, IntervalBinDescriptor.this.getIdentifier(), 1, bytes1[offset1], ATypeTag.SERIALIZED_DATE_TYPE_TAG, ATypeTag.SERIALIZED_TIME_TYPE_TAG, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
                            }
                        }
                        byte[] bytes2 = this.argPtr2.getByteArray();
                        int offset2 = this.argPtr2.getStartOffset();
                        ATypeTag type2 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes2[offset2]);
                        int yearMonth = 0;
                        long dayTime = 0L;
                        switch (type2) {
                            case YEARMONTHDURATION: {
                                yearMonth = AYearMonthDurationSerializerDeserializer.getYearMonth((byte[])bytes2, (int)(offset2 + 1));
                                int yearStart = this.GREG_CAL.getYear(chrononToStart);
                                int monthStart = this.GREG_CAL.getMonthOfYear(chrononToStart, yearStart);
                                int yearToBin = this.GREG_CAL.getYear(chrononToBin);
                                int monthToBin = this.GREG_CAL.getMonthOfYear(chrononToBin, yearToBin);
                                int totalMonths = (yearToBin - yearStart) * 12 + (monthToBin - monthStart);
                                binIndex = totalMonths / yearMonth + (totalMonths < 0 && totalMonths % yearMonth != 0 ? -1 : 0);
                                if (binIndex > Integer.MAX_VALUE) {
                                    throw new OverflowException(IntervalBinDescriptor.this.sourceLoc, IntervalBinDescriptor.this.getIdentifier());
                                }
                                if (binIndex >= Integer.MIN_VALUE) break;
                                throw new UnderflowException(IntervalBinDescriptor.this.sourceLoc, IntervalBinDescriptor.this.getIdentifier());
                            }
                            case DAYTIMEDURATION: {
                                dayTime = ADayTimeDurationSerializerDeserializer.getDayTime((byte[])bytes2, (int)(offset2 + 1));
                                long totalChronon = chrononToBin - chrononToStart;
                                binIndex = totalChronon / dayTime + (long)(totalChronon < 0L && totalChronon % dayTime != 0L ? -1 : 0);
                                break;
                            }
                            default: {
                                throw new TypeMismatchException(IntervalBinDescriptor.this.sourceLoc, IntervalBinDescriptor.this.getIdentifier(), 2, bytes2[offset2], ATypeTag.SERIALIZED_YEAR_MONTH_DURATION_TYPE_TAG, ATypeTag.SERIALIZED_DAY_TIME_DURATION_TYPE_TAG);
                            }
                        }
                        switch (type0) {
                            case DATE: {
                                binStartChronon = DurationArithmeticOperations.addDuration((long)chrononToStart, (int)(yearMonth * (int)binIndex), (long)(dayTime * binIndex), (boolean)false);
                                binEndChronon = DurationArithmeticOperations.addDuration((long)chrononToStart, (int)(yearMonth * ((int)binIndex + 1)), (long)(dayTime * (binIndex + 1L)), (boolean)false);
                                binStartChronon = binStartChronon / 86400000L + (long)(binStartChronon < 0L && binStartChronon % 86400000L != 0L ? -1 : 0);
                                binEndChronon = binEndChronon / 86400000L + (long)(binEndChronon < 0L && binEndChronon % 86400000L != 0L ? -1 : 0);
                                break;
                            }
                            case TIME: {
                                if (yearMonth != 0) {
                                    throw new InvalidDataFormatException(IntervalBinDescriptor.this.sourceLoc, IntervalBinDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_INTERVAL_TYPE_TAG);
                                }
                                binStartChronon = DurationArithmeticOperations.addDuration((long)chrononToStart, (int)(yearMonth * (int)binIndex), (long)(dayTime * binIndex), (boolean)true);
                                binEndChronon = DurationArithmeticOperations.addDuration((long)chrononToStart, (int)(yearMonth * ((int)binIndex + 1)), (long)(dayTime * (binIndex + 1L)), (boolean)true);
                                break;
                            }
                            case DATETIME: {
                                binStartChronon = DurationArithmeticOperations.addDuration((long)chrononToStart, (int)(yearMonth * (int)binIndex), (long)(dayTime * binIndex), (boolean)false);
                                binEndChronon = DurationArithmeticOperations.addDuration((long)chrononToStart, (int)(yearMonth * ((int)binIndex + 1)), (long)(dayTime * (binIndex + 1L)), (boolean)false);
                                break;
                            }
                            default: {
                                throw new TypeMismatchException(IntervalBinDescriptor.this.sourceLoc, IntervalBinDescriptor.this.getIdentifier(), 0, bytes0[offset0], ATypeTag.SERIALIZED_DATE_TYPE_TAG, ATypeTag.SERIALIZED_TIME_TYPE_TAG, ATypeTag.SERIALIZED_DATETIME_TYPE_TAG);
                            }
                        }
                        this.aInterval.setValue(binStartChronon, binEndChronon, type0.serialize());
                        this.intervalSerde.serialize((Object)this.aInterval, this.out);
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.INTERVAL_BIN;
    }
}

