/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.ProgressReporter;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.specialized.AppendBlobAsyncClient;
import com.azure.storage.blob.specialized.BlobAsyncClientBase;
import com.azure.storage.blob.specialized.BlockBlobAsyncClient;
import com.azure.storage.blob.specialized.PageBlobAsyncClient;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.implementation.UploadBufferPool;
import com.azure.storage.common.implementation.UploadUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BlobAsyncClient
extends BlobAsyncClientBase {
    public static final int BLOB_DEFAULT_UPLOAD_BLOCK_SIZE = 0x400000;
    public static final int BLOB_DEFAULT_NUMBER_OF_BUFFERS = 8;
    public static final int BLOB_DEFAULT_HTBB_UPLOAD_BLOCK_SIZE = 0x800000;
    static final int BLOB_MAX_UPLOAD_BLOCK_SIZE = 0x6400000;
    private final ClientLogger logger = new ClientLogger(BlobAsyncClient.class);

    protected BlobAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey) {
        super(pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey);
    }

    protected BlobAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope) {
        super(pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey, encryptionScope);
    }

    @Override
    public BlobAsyncClient getSnapshotClient(String snapshot) {
        return new BlobAsyncClient(this.getHttpPipeline(), this.getBlobUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), snapshot, this.getCustomerProvidedKey(), this.encryptionScope);
    }

    public AppendBlobAsyncClient getAppendBlobAsyncClient() {
        return this.prepareBuilder().buildAppendBlobAsyncClient();
    }

    public BlockBlobAsyncClient getBlockBlobAsyncClient() {
        return this.prepareBuilder().buildBlockBlobAsyncClient();
    }

    public PageBlobAsyncClient getPageBlobAsyncClient() {
        return this.prepareBuilder().buildPageBlobAsyncClient();
    }

    private SpecializedBlobClientBuilder prepareBuilder() {
        SpecializedBlobClientBuilder builder = new SpecializedBlobClientBuilder().pipeline(this.getHttpPipeline()).endpoint(this.getBlobUrl()).snapshot(this.getSnapshotId()).serviceVersion(this.getServiceVersion());
        CpkInfo cpk = this.getCustomerProvidedKey();
        if (cpk != null) {
            builder.customerProvidedKey(new CustomerProvidedKey(cpk.getEncryptionKey()));
        }
        if (this.encryptionScope != null) {
            builder.encryptionScope(this.encryptionScope.getEncryptionScope());
        }
        return builder;
    }

    public Mono<BlockBlobItem> upload(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions) {
        try {
            return this.upload(data, parallelTransferOptions, false);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<BlockBlobItem> upload(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions, boolean overwrite) {
        try {
            BlobRequestConditions requestConditions;
            Mono overwriteCheck;
            if (overwrite) {
                overwriteCheck = Mono.empty();
                requestConditions = null;
            } else {
                overwriteCheck = this.exists().flatMap(exists -> exists != false ? FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob.")) : Mono.empty());
                requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
            }
            return overwriteCheck.then(this.uploadWithResponse(data, parallelTransferOptions, null, null, null, requestConditions)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Response<BlockBlobItem>> uploadWithResponse(Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions) {
        try {
            Objects.requireNonNull(data, "'data' must not be null");
            BlobRequestConditions validatedRequestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
            ParallelTransferOptions validatedParallelTransferOptions = ModelHelper.populateAndApplyDefaults(parallelTransferOptions);
            BlockBlobAsyncClient blockBlobAsyncClient = this.getBlockBlobAsyncClient();
            Function<Flux, Mono> uploadInChunksFunction = stream -> this.uploadInChunks(blockBlobAsyncClient, (Flux<ByteBuffer>)stream, validatedParallelTransferOptions, headers, metadata, tier, validatedRequestConditions);
            BiFunction<Flux, Long, Mono> uploadFullBlobMethod = (stream, length) -> blockBlobAsyncClient.uploadWithResponse(ProgressReporter.addProgressReporting((Flux<ByteBuffer>)stream, validatedParallelTransferOptions.getProgressReceiver()), (long)length, headers, metadata, tier, null, validatedRequestConditions);
            return UploadUtils.uploadFullOrChunked(data, (com.azure.storage.common.ParallelTransferOptions)ModelHelper.wrapBlobOptions(validatedParallelTransferOptions), uploadInChunksFunction, uploadFullBlobMethod);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<Response<BlockBlobItem>> uploadInChunks(BlockBlobAsyncClient blockBlobAsyncClient, Flux<ByteBuffer> data, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions) {
        AtomicLong totalProgress = new AtomicLong();
        ReentrantLock progressLock = new ReentrantLock();
        UploadBufferPool pool = new UploadBufferPool(parallelTransferOptions.getNumBuffers().intValue(), parallelTransferOptions.getBlockSize().intValue(), 0x6400000);
        Flux chunkedSource = UploadUtils.chunkSource(data, (com.azure.storage.common.ParallelTransferOptions)ModelHelper.wrapBlobOptions(parallelTransferOptions));
        return chunkedSource.concatMap(arg_0 -> ((UploadBufferPool)pool).write(arg_0)).concatWith((Publisher)Flux.defer(() -> ((UploadBufferPool)pool).flush())).flatMapSequential(buffer -> {
            Flux<ByteBuffer> progressData = ProgressReporter.addParallelProgressReporting((Flux<ByteBuffer>)Flux.just((Object)buffer), parallelTransferOptions.getProgressReceiver(), progressLock, totalProgress);
            String blockId = Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8));
            return blockBlobAsyncClient.stageBlockWithResponse(blockId, progressData, buffer.remaining(), null, requestConditions.getLeaseId()).map(x -> blockId).doFinally(x -> pool.returnBuffer(buffer)).flux();
        }).collect(Collectors.toList()).flatMap(ids -> blockBlobAsyncClient.commitBlockListWithResponse((List<String>)ids, headers, metadata, tier, requestConditions));
    }

    public Mono<Void> uploadFromFile(String filePath) {
        try {
            return this.uploadFromFile(filePath, false);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Void> uploadFromFile(String filePath, boolean overwrite) {
        try {
            Mono overwriteCheck = Mono.empty();
            BlobRequestConditions requestConditions = null;
            if (!overwrite) {
                if (UploadUtils.shouldUploadInChunks((String)filePath, (Integer)0x10000000, (ClientLogger)this.logger)) {
                    overwriteCheck = this.exists().flatMap(exists -> exists != false ? FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("Blob already exists. Specify overwrite to true to force update the blob.")) : Mono.empty());
                }
                requestConditions = new BlobRequestConditions().setIfNoneMatch("*");
            }
            return overwriteCheck.then(this.uploadFromFile(filePath, null, null, null, null, requestConditions));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Void> uploadFromFile(String filePath, ParallelTransferOptions parallelTransferOptions, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions) {
        Integer originalBlockSize = parallelTransferOptions == null ? null : parallelTransferOptions.getBlockSize();
        ParallelTransferOptions finalParallelTransferOptions = ModelHelper.populateAndApplyDefaults(parallelTransferOptions);
        try {
            return Mono.using(() -> UploadUtils.uploadFileResourceSupplier((String)filePath, (ClientLogger)this.logger), channel -> {
                try {
                    BlockBlobAsyncClient blockBlobAsyncClient = this.getBlockBlobAsyncClient();
                    long fileSize = channel.size();
                    if (UploadUtils.shouldUploadInChunks((String)filePath, (Integer)finalParallelTransferOptions.getMaxSingleUploadSize(), (ClientLogger)this.logger)) {
                        return this.uploadFileChunks(fileSize, finalParallelTransferOptions, originalBlockSize, headers, metadata, tier, requestConditions, (AsynchronousFileChannel)channel, blockBlobAsyncClient);
                    }
                    Flux<ByteBuffer> data = FluxUtil.readFile((AsynchronousFileChannel)channel);
                    if (finalParallelTransferOptions.getProgressReceiver() != null) {
                        data = ProgressReporter.addProgressReporting(data, finalParallelTransferOptions.getProgressReceiver());
                    }
                    return blockBlobAsyncClient.uploadWithResponse(data, fileSize, headers, metadata, tier, null, requestConditions).then();
                }
                catch (IOException ex) {
                    return Mono.error((Throwable)ex);
                }
            }, channel -> UploadUtils.uploadFileCleanup((AsynchronousFileChannel)channel, (ClientLogger)this.logger));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private Mono<Void> uploadFileChunks(long fileSize, ParallelTransferOptions parallelTransferOptions, Integer originalBlockSize, BlobHttpHeaders headers, Map<String, String> metadata, AccessTier tier, BlobRequestConditions requestConditions, AsynchronousFileChannel channel, BlockBlobAsyncClient client) {
        BlobRequestConditions finalRequestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        AtomicLong totalProgress = new AtomicLong();
        ReentrantLock progressLock = new ReentrantLock();
        TreeMap blockIds = new TreeMap();
        return Flux.fromIterable(this.sliceFile(fileSize, originalBlockSize, parallelTransferOptions.getBlockSize())).flatMap(chunk -> {
            String blockId = this.getBlockID();
            blockIds.put(chunk.getOffset(), blockId);
            Flux<ByteBuffer> progressData = ProgressReporter.addParallelProgressReporting((Flux<ByteBuffer>)FluxUtil.readFile((AsynchronousFileChannel)channel, (long)chunk.getOffset(), (long)chunk.getCount()), parallelTransferOptions.getProgressReceiver(), progressLock, totalProgress);
            return client.stageBlockWithResponse(blockId, progressData, chunk.getCount(), null, finalRequestConditions.getLeaseId());
        }).then(Mono.defer(() -> client.commitBlockListWithResponse(new ArrayList<String>(blockIds.values()), headers, metadata, tier, finalRequestConditions))).then();
    }

    @Deprecated
    protected AsynchronousFileChannel uploadFileResourceSupplier(String filePath) {
        return UploadUtils.uploadFileResourceSupplier((String)filePath, (ClientLogger)this.logger);
    }

    private String getBlockID() {
        return Base64.getEncoder().encodeToString(UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8));
    }

    private List<BlobRange> sliceFile(long fileSize, Integer originalBlockSize, int blockSize) {
        ArrayList<BlobRange> ranges = new ArrayList<BlobRange>();
        if (fileSize > 0x6400000L && originalBlockSize == null) {
            blockSize = 0x800000;
        }
        for (long pos = 0L; pos < fileSize; pos += (long)blockSize) {
            long count = blockSize;
            if (pos + count > fileSize) {
                count = fileSize - pos;
            }
            ranges.add(new BlobRange(pos, count));
        }
        return ranges;
    }
}

