/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import io.micrometer.core.instrument.Gauge;
import reactor.netty.Metrics;
import reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;

final class PooledConnectionProviderMetrics {
    PooledConnectionProviderMetrics() {
    }

    static void registerMetrics(String poolName, String id, String remoteAddress, InstrumentedPool.PoolMetrics metrics) {
        String[] tags = new String[]{"id", id, "remote.address", remoteAddress};
        PooledConnectionProviderMetrics.registerMetricsInternal("reactor.netty.connection.provider." + poolName, metrics, tags);
        tags = new String[]{"id", id, "remote.address", remoteAddress, "name", poolName};
        PooledConnectionProviderMetrics.registerMetricsInternal("reactor.netty.connection.provider", metrics, tags);
    }

    private static void registerMetricsInternal(String name, InstrumentedPool.PoolMetrics metrics, String ... tags) {
        Gauge.builder((String)(name + ".total.connections"), (Object)metrics, InstrumentedPool.PoolMetrics::allocatedSize).description("The number of all connections, active or idle.").tags(tags).register(Metrics.REGISTRY);
        Gauge.builder((String)(name + ".active.connections"), (Object)metrics, InstrumentedPool.PoolMetrics::acquiredSize).description("The number of the connections that have been successfully acquired and are in active use").tags(tags).register(Metrics.REGISTRY);
        Gauge.builder((String)(name + ".idle.connections"), (Object)metrics, InstrumentedPool.PoolMetrics::idleSize).description("The number of the idle connections").tags(tags).register(Metrics.REGISTRY);
        Gauge.builder((String)(name + ".pending.connections"), (Object)metrics, InstrumentedPool.PoolMetrics::pendingAcquireSize).description("The number of the request, that are pending acquire a connection").tags(tags).register(Metrics.REGISTRY);
    }
}

