/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.common.NumberUtils;
import org.apache.asterix.runtime.evaluators.constructors.AbstractConstructorEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

public abstract class AbstractDoubleConstructorEvaluator
extends AbstractConstructorEvaluator {
    protected final AMutableDouble aDouble = new AMutableDouble(0.0);
    protected final ISerializerDeserializer<ADouble> doubleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
    protected final UTF8StringPointable utf8Ptr = new UTF8StringPointable();

    protected AbstractDoubleConstructorEvaluator(IEvaluatorContext ctx, IScalarEvaluator inputEval, SourceLocation sourceLoc) {
        super(ctx, inputEval, sourceLoc);
    }

    @Override
    protected void evaluateImpl(IPointable result) throws HyracksDataException {
        byte[] bytes = this.inputArg.getByteArray();
        int startOffset = this.inputArg.getStartOffset();
        int len = this.inputArg.getLength();
        ATypeTag inputType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[startOffset]);
        switch (inputType) {
            case DOUBLE: {
                result.set((IValueReference)this.inputArg);
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: {
                this.resultStorage.reset();
                try {
                    ATypeHierarchy.getTypePromoteComputer((ATypeTag)inputType, (ATypeTag)ATypeTag.DOUBLE).convertType(bytes, startOffset + 1, len - 1, this.out);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
                result.set((IValueReference)this.resultStorage);
                break;
            }
            case BOOLEAN: {
                this.resultStorage.reset();
                boolean b = ABooleanSerializerDeserializer.getBoolean((byte[])bytes, (int)(startOffset + 1));
                this.aDouble.setValue(b ? 1.0 : 0.0);
                this.doubleSerde.serialize((Object)this.aDouble, this.out);
                result.set((IValueReference)this.resultStorage);
                break;
            }
            case STRING: {
                this.utf8Ptr.set(bytes, startOffset + 1, len - 1);
                if (NumberUtils.parseDouble(this.utf8Ptr, this.aDouble)) {
                    this.resultStorage.reset();
                    this.doubleSerde.serialize((Object)this.aDouble, this.out);
                    result.set((IValueReference)this.resultStorage);
                    break;
                }
                this.handleParseError(this.utf8Ptr, result);
                break;
            }
            default: {
                this.handleUnsupportedType(inputType, result);
            }
        }
    }

    @Override
    protected BuiltinType getTargetType() {
        return BuiltinType.ADOUBLE;
    }
}

