/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.dataflow.data.nontagged.serde.ACircleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ALineSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AObjectSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.APointSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.APolygonSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ARectangleSerializerDeserializer;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.DoubleArray;
import org.apache.asterix.runtime.evaluators.common.IntArray;
import org.apache.asterix.runtime.evaluators.common.SpatialUtils;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class SpatialIntersectDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = SpatialIntersectDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final DataOutput out = this.resultStorage.getDataOutput();
                    private final IPointable inputArg0 = new VoidPointable();
                    private final IPointable inputArg1 = new VoidPointable();
                    private final IScalarEvaluator eval0;
                    private final IScalarEvaluator eval1;
                    private final IBinaryComparator ascDoubleComp;
                    private final SpatialUtils spatialUtils;
                    private final IntArray pointsOffsets0;
                    private final IntArray pointsOffsets1;
                    private final DoubleArray trianglesX0;
                    private final DoubleArray trianglesY0;
                    private final DoubleArray trianglesX1;
                    private final DoubleArray trianglesY1;
                    private final AObjectSerializerDeserializer aBooleanSerDer;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.eval1 = args[1].createScalarEvaluator(ctx);
                        this.ascDoubleComp = BinaryComparatorFactoryProvider.DOUBLE_POINTABLE_INSTANCE.createBinaryComparator();
                        this.spatialUtils = new SpatialUtils();
                        this.pointsOffsets0 = new IntArray();
                        this.pointsOffsets1 = new IntArray();
                        this.trianglesX0 = new DoubleArray();
                        this.trianglesY0 = new DoubleArray();
                        this.trianglesX1 = new DoubleArray();
                        this.trianglesY1 = new DoubleArray();
                        this.aBooleanSerDer = AObjectSerializerDeserializer.INSTANCE;
                    }

                    private boolean pointOnLine(double pX, double pY, double startX, double startY, double endX, double endY) throws HyracksDataException {
                        double crossProduct = SpatialUtils.crossProduct(pY - startY, pX - startX, endY - startY, endX - startX);
                        if (Math.abs(crossProduct) > SpatialUtils.doubleEpsilon()) {
                            return false;
                        }
                        double dotProduct = SpatialUtils.dotProduct(pX - startX, pY - startY, endX - startX, endY - startY);
                        if (dotProduct < 0.0) {
                            return false;
                        }
                        double squaredLengthBA = (endX - startX) * (endX - startX) + (endY - startY) * (endY - startY);
                        return !(dotProduct > squaredLengthBA);
                    }

                    private boolean pointInPolygon(byte[] bytes0, int offset0, byte[] bytes1, int offset1) throws HyracksDataException {
                        double pX = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.X)));
                        double pY = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.Y)));
                        int numOfPoints1 = AInt16SerializerDeserializer.getShort((byte[])bytes1, (int)(offset1 + 1 + APolygonSerializerDeserializer.getNumberOfPointsOffset()));
                        if (numOfPoints1 < 3) {
                            throw new InvalidDataFormatException(SpatialIntersectDescriptor.this.sourceLoc, SpatialIntersectDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_POLYGON_TYPE_TAG);
                        }
                        int counter = 0;
                        double x1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)0, (Coordinate)Coordinate.X)));
                        double y1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)0, (Coordinate)Coordinate.Y)));
                        for (int i = 1; i <= numOfPoints1; ++i) {
                            double y2;
                            double x2;
                            if (i == numOfPoints1) {
                                x2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)0, (Coordinate)Coordinate.X)));
                                y2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)0, (Coordinate)Coordinate.Y)));
                            } else {
                                x2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)i, (Coordinate)Coordinate.X)));
                                y2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)i, (Coordinate)Coordinate.Y)));
                            }
                            if (!this.pointOnLine(pX, pY, x1, y1, x2, y2) && pY > Math.min(y1, y2) && pY <= Math.max(y1, y2) && pX <= Math.max(x1, x2) && y1 != y2) {
                                double xInters = (pY - y1) * (x2 - x1) / (y2 - y1) + x1;
                                if (x1 == x2 || pX <= xInters) {
                                    ++counter;
                                }
                            }
                            x1 = x2;
                            y1 = y2;
                        }
                        return counter % 2 == 1;
                    }

                    private boolean pointInCircle(byte[] bytes0, int offset0, byte[] bytes1, int offset1) throws HyracksDataException {
                        double radius;
                        double cY;
                        double x = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.X)));
                        double y = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.Y)));
                        double cX = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ACircleSerializerDeserializer.getCenterPointCoordinateOffset((Coordinate)Coordinate.X)));
                        return (x - cX) * (x - cX) + (y - (cY = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ACircleSerializerDeserializer.getCenterPointCoordinateOffset((Coordinate)Coordinate.Y))))) * (y - cY) <= (radius = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ACircleSerializerDeserializer.getRadiusOffset()))) * radius;
                    }

                    private boolean lineLineIntersection(double startX1, double startY1, double endX1, double endY1, double startX2, double startY2, double endX2, double endY2) {
                        double A1 = endY1 - startY1;
                        double B1 = startX1 - endX1;
                        double C1 = A1 * startX1 + B1 * startY1;
                        double A2 = endY2 - startY2;
                        double B2 = startX2 - endX2;
                        double C2 = A2 * startX2 + B2 * startY2;
                        double det = A1 * B2 - A2 * B1;
                        if (Math.abs(det) > SpatialUtils.doubleEpsilon()) {
                            double x = (B2 * C1 - B1 * C2) / det;
                            double y = (A1 * C2 - A2 * C1) / det;
                            if (x >= Math.min(startX1, endX1) && x <= Math.max(startX1, endX1) && y >= Math.min(startY1, endY1) && y <= Math.max(startY1, endY1) && x >= Math.min(startX2, endX2) && x <= Math.max(startX2, endX2) && y >= Math.min(startY2, endY2) && y <= Math.max(startY2, endY2)) {
                                return true;
                            }
                        }
                        return false;
                    }

                    private boolean linePolygonIntersection(byte[] bytes0, int offset0, byte[] bytes1, int offset1) throws HyracksDataException {
                        double startX1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getStartPointCoordinateOffset((Coordinate)Coordinate.X)));
                        double startY1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getStartPointCoordinateOffset((Coordinate)Coordinate.Y)));
                        double endX1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getEndPointCoordinateOffset((Coordinate)Coordinate.X)));
                        double endY1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getEndPointCoordinateOffset((Coordinate)Coordinate.Y)));
                        int numOfPoints1 = AInt16SerializerDeserializer.getShort((byte[])bytes1, (int)(offset1 + 1 + APolygonSerializerDeserializer.getNumberOfPointsOffset()));
                        if (numOfPoints1 < 3) {
                            throw new InvalidDataFormatException(SpatialIntersectDescriptor.this.sourceLoc, SpatialIntersectDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_POLYGON_TYPE_TAG);
                        }
                        for (int i = 0; i < numOfPoints1; ++i) {
                            double endY2;
                            double endX2;
                            double startX2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)i, (Coordinate)Coordinate.X)));
                            double startY2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)i, (Coordinate)Coordinate.Y)));
                            if (i + 1 == numOfPoints1) {
                                endX2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)0, (Coordinate)Coordinate.X)));
                                endY2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)0, (Coordinate)Coordinate.Y)));
                            } else {
                                endX2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)(i + 1), (Coordinate)Coordinate.X)));
                                endY2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)(i + 1), (Coordinate)Coordinate.Y)));
                            }
                            boolean intersect = this.lineLineIntersection(startX1, startY1, endX1, endY1, startX2, startY2, endX2, endY2);
                            if (!intersect) continue;
                            return true;
                        }
                        return false;
                    }

                    private boolean lineRectangleIntersection(byte[] bytes0, int offset0, byte[] bytes1, int offset1) throws HyracksDataException {
                        double startX1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getStartPointCoordinateOffset((Coordinate)Coordinate.X)));
                        double startY1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getStartPointCoordinateOffset((Coordinate)Coordinate.Y)));
                        double endX1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getEndPointCoordinateOffset((Coordinate)Coordinate.X)));
                        double endY1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getEndPointCoordinateOffset((Coordinate)Coordinate.Y)));
                        double x1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.X)));
                        double y1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.Y)));
                        double x2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.X)));
                        double y2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.Y)));
                        return this.lineLineIntersection(startX1, startY1, endX1, endY1, x1, y1, x1, y2) || this.lineLineIntersection(startX1, startY1, endX1, endY1, x1, y2, x2, y2) || this.lineLineIntersection(startX1, startY1, endX1, endY1, x2, y2, x2, y1) || this.lineLineIntersection(startX1, startY1, endX1, endY1, x2, y1, x1, y1);
                    }

                    private boolean lineCircleIntersection(byte[] bytes0, int offset0, byte[] bytes1, int offset1) throws HyracksDataException {
                        double startX = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getStartPointCoordinateOffset((Coordinate)Coordinate.X)));
                        double startY = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getStartPointCoordinateOffset((Coordinate)Coordinate.Y)));
                        double endX = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getEndPointCoordinateOffset((Coordinate)Coordinate.X)));
                        double endY = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getEndPointCoordinateOffset((Coordinate)Coordinate.Y)));
                        double cX = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ACircleSerializerDeserializer.getCenterPointCoordinateOffset((Coordinate)Coordinate.X)));
                        double cY = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ACircleSerializerDeserializer.getCenterPointCoordinateOffset((Coordinate)Coordinate.Y)));
                        double radius = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ACircleSerializerDeserializer.getRadiusOffset()));
                        double dx = endX - startX;
                        double dy = endY - startY;
                        double t = -((startX - cX) * dx + (startY - cY) * dy) / (dx * dx + dy * dy);
                        if (t < 0.0) {
                            t = 0.0;
                        } else if (t > 1.0) {
                            t = 1.0;
                        }
                        dx = startX + t * (endX - startX) - cX;
                        dy = startY + t * (endY - startY) - cY;
                        double rt = dx * dx + dy * dy;
                        return rt <= radius * radius;
                    }

                    private boolean findEar(byte[] bytes, int offset, int u, int v, int w, int n, IntArray pointsOffsets) throws HyracksDataException {
                        double Ax = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)pointsOffsets.get(u), (Coordinate)Coordinate.X)));
                        double Ay = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)pointsOffsets.get(u), (Coordinate)Coordinate.Y)));
                        double Bx = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)pointsOffsets.get(v), (Coordinate)Coordinate.X)));
                        double By = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)pointsOffsets.get(v), (Coordinate)Coordinate.Y)));
                        double Cx = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)pointsOffsets.get(w), (Coordinate)Coordinate.X)));
                        double Cy = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)pointsOffsets.get(w), (Coordinate)Coordinate.Y)));
                        if (SpatialUtils.doubleEpsilon() > (Bx - Ax) * (Cy - Ay) - (By - Ay) * (Cx - Ax)) {
                            return false;
                        }
                        for (int p = 0; p < n; ++p) {
                            double Py;
                            double Px;
                            if (p == u || p == v || p == w || !this.pointInsideTriangle(Ax, Ay, Bx, By, Cx, Cy, Px = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)pointsOffsets.get(p), (Coordinate)Coordinate.X))), Py = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)pointsOffsets.get(p), (Coordinate)Coordinate.Y))))) continue;
                            return false;
                        }
                        return true;
                    }

                    private int triangulatePolygon(byte[] bytes, int offset, int numOfPoints, IntArray pointsOffsets, DoubleArray trianglesX, DoubleArray trianglesY, int triangleId, int nonSimplePolygonDetection, int middleVertex) throws HyracksDataException {
                        if (numOfPoints < 3) {
                            return -1;
                        }
                        boolean foundEar = false;
                        int v = middleVertex;
                        while (!foundEar) {
                            int w;
                            if (0 >= nonSimplePolygonDetection--) {
                                throw new InvalidDataFormatException(SpatialIntersectDescriptor.this.sourceLoc, SpatialIntersectDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_POLYGON_TYPE_TAG);
                            }
                            int u = v;
                            if (numOfPoints <= u) {
                                u = 0;
                            }
                            if (numOfPoints <= (v = u + 1)) {
                                v = 0;
                            }
                            if (numOfPoints <= (w = v + 1)) {
                                w = 0;
                            }
                            if (!this.findEar(bytes, offset, u, v, w, numOfPoints, pointsOffsets)) continue;
                            this.addRectangle(trianglesX, trianglesY);
                            SpatialUtils.setTriangleXCoordinate(trianglesX, triangleId, 0, ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)pointsOffsets.get(u), (Coordinate)Coordinate.X))));
                            SpatialUtils.setTriangleYCoordinate(trianglesY, triangleId, 0, ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)pointsOffsets.get(u), (Coordinate)Coordinate.Y))));
                            SpatialUtils.setTriangleXCoordinate(trianglesX, triangleId, 1, ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)pointsOffsets.get(v), (Coordinate)Coordinate.X))));
                            SpatialUtils.setTriangleYCoordinate(trianglesY, triangleId, 1, ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)pointsOffsets.get(v), (Coordinate)Coordinate.Y))));
                            SpatialUtils.setTriangleXCoordinate(trianglesX, triangleId, 2, ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)pointsOffsets.get(w), (Coordinate)Coordinate.X))));
                            SpatialUtils.setTriangleYCoordinate(trianglesY, triangleId, 2, ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + APolygonSerializerDeserializer.getCoordinateOffset((int)pointsOffsets.get(w), (Coordinate)Coordinate.Y))));
                            int s = v;
                            for (int t = v + 1; t < numOfPoints; ++t) {
                                pointsOffsets.get()[s] = pointsOffsets.get(t);
                                ++s;
                            }
                            foundEar = true;
                        }
                        return v;
                    }

                    private boolean triangleTriangleIntersection(DoubleArray trianglesX0, DoubleArray trianglesY0, int triangleId0, DoubleArray trianglesX1, DoubleArray trianglesY1, int triangleId1) throws HyracksDataException {
                        for (int side = 0; side < 3; ++side) {
                            this.spatialUtils.findNormals(trianglesX0, trianglesY0, triangleId0, side);
                            this.spatialUtils.projectPolygon(trianglesX0, trianglesY0, triangleId0, this.spatialUtils.getXAxis(), this.spatialUtils.getYAxis());
                            double min1 = this.spatialUtils.getMinProjection();
                            double max1 = this.spatialUtils.getMaxProjection();
                            this.spatialUtils.projectPolygon(trianglesX1, trianglesY1, triangleId1, this.spatialUtils.getXAxis(), this.spatialUtils.getYAxis());
                            double min2 = this.spatialUtils.getMinProjection();
                            double max2 = this.spatialUtils.getMaxProjection();
                            if (!(max1 < min2) && !(min1 > max2)) continue;
                            return false;
                        }
                        return true;
                    }

                    private boolean pointInsideTriangle(double x1, double y1, double x2, double y2, double x3, double y3, double pX, double pY) {
                        return this.pointsOnSameSide(pX, pY, x1, y1, x2, y2, x3, y3) && this.pointsOnSameSide(pX, pY, x2, y2, x1, y1, x3, y3) && this.pointsOnSameSide(pX, pY, x3, y3, x1, y1, x2, y2);
                    }

                    private boolean pointsOnSameSide(double pX, double pY, double x1, double y1, double x2, double y2, double x3, double y3) {
                        double cp2;
                        double cp1 = SpatialUtils.crossProduct(x3 - x2, y3 - y2, pX - x2, pY - y2);
                        return cp1 * (cp2 = SpatialUtils.crossProduct(x3 - x2, y3 - y2, x1 - x2, y1 - y2)) >= 0.0;
                    }

                    private boolean circleTriangleIntersection(byte[] bytes0, int offset0, DoubleArray trianglesX, DoubleArray trianglesY, int triangleId) throws HyracksDataException {
                        double cX = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ACircleSerializerDeserializer.getCenterPointCoordinateOffset((Coordinate)Coordinate.X)));
                        double cY = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ACircleSerializerDeserializer.getCenterPointCoordinateOffset((Coordinate)Coordinate.Y)));
                        double radius = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ACircleSerializerDeserializer.getRadiusOffset()));
                        double distance = Double.MAX_VALUE;
                        double closestPointX = 0.0;
                        double closestPointY = 0.0;
                        for (int i = 0; i < 3; ++i) {
                            double pY;
                            double pX = SpatialUtils.getTriangleXCoordinate(trianglesX, triangleId, i);
                            double distanceSquared = (cX - pX) * (cX - pX) + (cY - (pY = SpatialUtils.getTriangleXCoordinate(trianglesY, triangleId, i))) * (cY - pY);
                            if (!(distanceSquared < distance)) continue;
                            distance = distanceSquared;
                            closestPointX = pX;
                            closestPointY = pY;
                        }
                        double x = Math.abs(cX - closestPointX);
                        double y = Math.abs(cY - closestPointY);
                        double temp = Math.sqrt(SpatialUtils.dotProduct(x, y, x, y));
                        this.spatialUtils.projectPolygon(trianglesX, trianglesY, triangleId, x /= temp, y /= temp);
                        double min1 = this.spatialUtils.getMinProjection();
                        double max1 = this.spatialUtils.getMaxProjection();
                        double dotProduct = SpatialUtils.dotProduct(x, y, cX, cY);
                        double max2 = dotProduct + radius;
                        double min2 = dotProduct - radius;
                        if (max1 < min2 || min1 > max2) {
                            return false;
                        }
                        for (int side = 0; side < 3; ++side) {
                            this.spatialUtils.findNormals(trianglesX, trianglesY, triangleId, side);
                            this.spatialUtils.projectPolygon(trianglesX, trianglesY, triangleId, this.spatialUtils.getXAxis(), this.spatialUtils.getYAxis());
                            min1 = this.spatialUtils.getMinProjection();
                            max1 = this.spatialUtils.getMaxProjection();
                            dotProduct = SpatialUtils.dotProduct(this.spatialUtils.getXAxis(), this.spatialUtils.getYAxis(), cX, cY);
                            max2 = dotProduct + radius;
                            min2 = dotProduct - radius;
                            if (!(max1 < min2) && !(min1 > max2)) continue;
                            return false;
                        }
                        return true;
                    }

                    private boolean circleCircleIntersection(byte[] bytes0, int offset0, byte[] bytes1, int offset1) throws HyracksDataException {
                        double radiusDistanceSquared;
                        double cX0 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ACircleSerializerDeserializer.getCenterPointCoordinateOffset((Coordinate)Coordinate.X)));
                        double cY0 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ACircleSerializerDeserializer.getCenterPointCoordinateOffset((Coordinate)Coordinate.Y)));
                        double radius0 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ACircleSerializerDeserializer.getRadiusOffset()));
                        double cX1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ACircleSerializerDeserializer.getCenterPointCoordinateOffset((Coordinate)Coordinate.X)));
                        double cY1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ACircleSerializerDeserializer.getCenterPointCoordinateOffset((Coordinate)Coordinate.Y)));
                        double radius1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ACircleSerializerDeserializer.getRadiusOffset()));
                        double distanceSquared = SpatialUtils.dotProduct(cX0 - cX1, cY0 - cY1, cX0 - cX1, cY0 - cY1);
                        return distanceSquared <= (radiusDistanceSquared = (radius0 + radius1) * (radius0 + radius1));
                    }

                    private void getCounterClockWisePolygon(byte[] bytes, int offset, IntArray pointsOffsets, int numOfPoints) throws HyracksDataException {
                        pointsOffsets.reset();
                        if (SpatialUtils.polygonArea(bytes, offset, numOfPoints) > 0.0) {
                            for (int i = 0; i < numOfPoints; ++i) {
                                pointsOffsets.add(i);
                            }
                        } else {
                            for (int i = 0; i < numOfPoints; ++i) {
                                pointsOffsets.add(numOfPoints - 1 - i);
                            }
                        }
                    }

                    private boolean pointInRectangle(byte[] bytes0, int offset0, byte[] bytes1, int offset1) throws HyracksDataException {
                        double pX = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.X)));
                        double pY = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.Y)));
                        double x1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.X)));
                        double y1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.Y)));
                        double x2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.X)));
                        double y2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.Y)));
                        return this.pointInsideTriangle(x1, y1, x1, y2, x2, y2, pX, pY) || this.pointInsideTriangle(x1, y1, x2, y1, x2, y2, pX, pY);
                    }

                    private void addRectangle(DoubleArray trianglesX, DoubleArray trianglesY) {
                        for (int i = 0; i < 3; ++i) {
                            double temp = 0.0;
                            trianglesX.add(temp);
                            trianglesY.add(temp);
                        }
                    }

                    private boolean rectangleCircleIntersection(byte[] bytes0, int offset0, byte[] bytes1, int offset1) throws HyracksDataException {
                        this.triangulateRectangle(bytes0, offset0, this.trianglesX0, this.trianglesY0);
                        boolean res = false;
                        for (int i = 0; i < 2 && !(res = this.circleTriangleIntersection(bytes1, offset1, this.trianglesX0, this.trianglesY0, i)); ++i) {
                        }
                        return res;
                    }

                    private void triangulateRectangle(byte[] bytes, int offset, DoubleArray trianglesX, DoubleArray trianglesY) throws HyracksDataException {
                        double x1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.X)));
                        double y1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.Y)));
                        double x2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.X)));
                        double y2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.Y)));
                        trianglesX.reset();
                        trianglesY.reset();
                        this.addRectangle(trianglesX, trianglesY);
                        this.addRectangle(trianglesX, trianglesY);
                        SpatialUtils.setTriangleXCoordinate(trianglesX, 0, 0, x1);
                        SpatialUtils.setTriangleYCoordinate(trianglesY, 0, 0, y1);
                        SpatialUtils.setTriangleXCoordinate(trianglesX, 0, 1, x2);
                        SpatialUtils.setTriangleYCoordinate(trianglesY, 0, 1, y1);
                        SpatialUtils.setTriangleXCoordinate(trianglesX, 0, 2, x2);
                        SpatialUtils.setTriangleYCoordinate(trianglesY, 0, 2, y2);
                        SpatialUtils.setTriangleXCoordinate(trianglesX, 1, 0, x2);
                        SpatialUtils.setTriangleYCoordinate(trianglesY, 1, 0, y2);
                        SpatialUtils.setTriangleXCoordinate(trianglesX, 1, 1, x1);
                        SpatialUtils.setTriangleYCoordinate(trianglesY, 1, 1, y2);
                        SpatialUtils.setTriangleXCoordinate(trianglesX, 1, 2, x1);
                        SpatialUtils.setTriangleYCoordinate(trianglesY, 1, 2, y1);
                    }

                    private boolean rectanglePolygonIntersection(byte[] bytes0, int offset0, byte[] bytes1, int offset1) throws HyracksDataException {
                        int numOfPoints1 = AInt16SerializerDeserializer.getShort((byte[])bytes1, (int)(offset1 + 1 + APolygonSerializerDeserializer.getNumberOfPointsOffset()));
                        if (numOfPoints1 < 3) {
                            throw new InvalidDataFormatException(SpatialIntersectDescriptor.this.sourceLoc, SpatialIntersectDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_POLYGON_TYPE_TAG);
                        }
                        this.getCounterClockWisePolygon(bytes1, offset1, this.pointsOffsets1, numOfPoints1);
                        int nonSimplePolygonDetection1 = 2 * numOfPoints1;
                        int middleVertex1 = numOfPoints1 - 1;
                        int numOfTriangles1 = 0;
                        this.trianglesX1.reset();
                        this.trianglesY1.reset();
                        while ((middleVertex1 = this.triangulatePolygon(bytes1, offset1, numOfPoints1, this.pointsOffsets1, this.trianglesX1, this.trianglesY1, numOfTriangles1, nonSimplePolygonDetection1, middleVertex1)) != -1) {
                            nonSimplePolygonDetection1 = 2 * --numOfPoints1;
                            ++numOfTriangles1;
                        }
                        this.triangulateRectangle(bytes0, offset0, this.trianglesX0, this.trianglesY0);
                        boolean res = false;
                        for (int j = 0; j < 2; ++j) {
                            for (int i = 0; i < numOfTriangles1; ++i) {
                                res = this.triangleTriangleIntersection(this.trianglesX1, this.trianglesY1, i, this.trianglesX0, this.trianglesY0, j);
                                if (!res || !(res = this.triangleTriangleIntersection(this.trianglesX0, this.trianglesY0, j, this.trianglesX1, this.trianglesY1, i))) continue;
                                return true;
                            }
                        }
                        return false;
                    }

                    private boolean polygonCircleIntersection(byte[] bytes0, int offset0, byte[] bytes1, int offset1) throws HyracksDataException {
                        int numOfPoints = AInt16SerializerDeserializer.getShort((byte[])bytes0, (int)(offset0 + 1 + APolygonSerializerDeserializer.getNumberOfPointsOffset()));
                        if (numOfPoints < 3) {
                            throw new InvalidDataFormatException(SpatialIntersectDescriptor.this.sourceLoc, SpatialIntersectDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_POLYGON_TYPE_TAG);
                        }
                        this.getCounterClockWisePolygon(bytes0, offset0, this.pointsOffsets0, numOfPoints);
                        int nonSimplePolygonDetection = 2 * numOfPoints;
                        int middleVertex = numOfPoints - 1;
                        int numOfTriangles = 0;
                        this.trianglesX0.reset();
                        this.trianglesY0.reset();
                        boolean res = false;
                        while ((middleVertex = this.triangulatePolygon(bytes0, offset0, numOfPoints, this.pointsOffsets0, this.trianglesX0, this.trianglesY0, numOfTriangles, nonSimplePolygonDetection, middleVertex)) != -1) {
                            nonSimplePolygonDetection = 2 * --numOfPoints;
                            ++numOfTriangles;
                            int lastTriangle = this.trianglesX0.length() / 3 - 1;
                            res = this.circleTriangleIntersection(bytes1, offset1, this.trianglesX0, this.trianglesY0, lastTriangle);
                            if (!res) continue;
                            return true;
                        }
                        return false;
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.eval0.evaluate(tuple, this.inputArg0);
                        this.eval1.evaluate(tuple, this.inputArg1);
                        if (PointableHelper.checkAndSetMissingOrNull(result, this.inputArg0, this.inputArg1)) {
                            return;
                        }
                        byte[] bytes0 = this.inputArg0.getByteArray();
                        byte[] bytes1 = this.inputArg1.getByteArray();
                        int offset0 = this.inputArg0.getStartOffset();
                        int offset1 = this.inputArg1.getStartOffset();
                        boolean res = false;
                        ATypeTag tag0 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes0[offset0]);
                        ATypeTag tag1 = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes1[offset1]);
                        block0 : switch (tag0) {
                            case POINT: {
                                switch (tag1) {
                                    case POINT: {
                                        if (this.ascDoubleComp.compare(bytes0, offset0 + 1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.X), 8, bytes1, offset1 + 1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.X), 8) != 0 || this.ascDoubleComp.compare(bytes0, offset0 + 1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.Y), 8, bytes1, offset1 + 1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.Y), 8) != 0) break block0;
                                        res = true;
                                        break block0;
                                    }
                                    case LINE: {
                                        double pX = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.X)));
                                        double pY = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.Y)));
                                        double startX = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ALineSerializerDeserializer.getStartPointCoordinateOffset((Coordinate)Coordinate.X)));
                                        double startY = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ALineSerializerDeserializer.getStartPointCoordinateOffset((Coordinate)Coordinate.Y)));
                                        double endX = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ALineSerializerDeserializer.getEndPointCoordinateOffset((Coordinate)Coordinate.X)));
                                        double endY = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ALineSerializerDeserializer.getEndPointCoordinateOffset((Coordinate)Coordinate.Y)));
                                        res = this.pointOnLine(pX, pY, startX, startY, endX, endY);
                                        break block0;
                                    }
                                    case POLYGON: {
                                        res = this.pointInPolygon(bytes0, offset0, bytes1, offset1);
                                        break block0;
                                    }
                                    case CIRCLE: {
                                        res = this.pointInCircle(bytes0, offset0, bytes1, offset1);
                                        break block0;
                                    }
                                    case RECTANGLE: {
                                        res = this.pointInRectangle(bytes0, offset0, bytes1, offset1);
                                        break block0;
                                    }
                                    default: {
                                        throw new TypeMismatchException(SpatialIntersectDescriptor.this.sourceLoc, SpatialIntersectDescriptor.this.getIdentifier(), 1, bytes1[offset1], ATypeTag.SERIALIZED_POINT_TYPE_TAG, ATypeTag.SERIALIZED_LINE_TYPE_TAG, ATypeTag.SERIALIZED_POLYGON_TYPE_TAG, ATypeTag.SERIALIZED_CIRCLE_TYPE_TAG, ATypeTag.SERIALIZED_RECTANGLE_TYPE_TAG);
                                    }
                                }
                            }
                            case LINE: {
                                switch (tag1) {
                                    case POINT: {
                                        double pX = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.X)));
                                        double pY = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.Y)));
                                        double startX = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getStartPointCoordinateOffset((Coordinate)Coordinate.X)));
                                        double startY = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getStartPointCoordinateOffset((Coordinate)Coordinate.Y)));
                                        double endX = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getEndPointCoordinateOffset((Coordinate)Coordinate.X)));
                                        double endY = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getEndPointCoordinateOffset((Coordinate)Coordinate.Y)));
                                        res = this.pointOnLine(pX, pY, startX, startY, endX, endY);
                                        break block0;
                                    }
                                    case LINE: {
                                        double startX1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getStartPointCoordinateOffset((Coordinate)Coordinate.X)));
                                        double startY1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getStartPointCoordinateOffset((Coordinate)Coordinate.Y)));
                                        double endX1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getEndPointCoordinateOffset((Coordinate)Coordinate.X)));
                                        double endY1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + ALineSerializerDeserializer.getEndPointCoordinateOffset((Coordinate)Coordinate.Y)));
                                        double startX2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ALineSerializerDeserializer.getStartPointCoordinateOffset((Coordinate)Coordinate.X)));
                                        double startY2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ALineSerializerDeserializer.getStartPointCoordinateOffset((Coordinate)Coordinate.Y)));
                                        double endX2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ALineSerializerDeserializer.getEndPointCoordinateOffset((Coordinate)Coordinate.X)));
                                        double endY2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + ALineSerializerDeserializer.getEndPointCoordinateOffset((Coordinate)Coordinate.Y)));
                                        res = this.lineLineIntersection(startX1, startY1, endX1, endY1, startX2, startY2, endX2, endY2);
                                        break block0;
                                    }
                                    case POLYGON: {
                                        res = this.linePolygonIntersection(bytes0, offset0, bytes1, offset1);
                                        break block0;
                                    }
                                    case CIRCLE: {
                                        res = this.lineCircleIntersection(bytes0, offset0, bytes1, offset1);
                                        break block0;
                                    }
                                    case RECTANGLE: {
                                        res = this.lineRectangleIntersection(bytes0, offset0, bytes1, offset1);
                                        break block0;
                                    }
                                }
                                throw new TypeMismatchException(SpatialIntersectDescriptor.this.sourceLoc, SpatialIntersectDescriptor.this.getIdentifier(), 1, bytes1[offset1], ATypeTag.SERIALIZED_POINT_TYPE_TAG, ATypeTag.SERIALIZED_LINE_TYPE_TAG, ATypeTag.SERIALIZED_POLYGON_TYPE_TAG, ATypeTag.SERIALIZED_CIRCLE_TYPE_TAG, ATypeTag.SERIALIZED_RECTANGLE_TYPE_TAG);
                            }
                            case POLYGON: {
                                switch (tag1) {
                                    case POINT: {
                                        res = this.pointInPolygon(bytes1, offset1, bytes0, offset0);
                                        break block0;
                                    }
                                    case LINE: {
                                        res = this.linePolygonIntersection(bytes1, offset1, bytes0, offset0);
                                        break block0;
                                    }
                                    case POLYGON: {
                                        int numOfPoints0 = AInt16SerializerDeserializer.getShort((byte[])bytes0, (int)(offset0 + 1 + APolygonSerializerDeserializer.getNumberOfPointsOffset()));
                                        int numOfPoints1 = AInt16SerializerDeserializer.getShort((byte[])bytes1, (int)(offset1 + 1 + APolygonSerializerDeserializer.getNumberOfPointsOffset()));
                                        if (numOfPoints0 < 3 || numOfPoints1 < 3) {
                                            throw new InvalidDataFormatException(SpatialIntersectDescriptor.this.sourceLoc, SpatialIntersectDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_POLYGON_TYPE_TAG);
                                        }
                                        this.getCounterClockWisePolygon(bytes0, offset0, this.pointsOffsets0, numOfPoints0);
                                        this.getCounterClockWisePolygon(bytes1, offset1, this.pointsOffsets1, numOfPoints1);
                                        int nonSimplePolygonDetection0 = 2 * numOfPoints0;
                                        int nonSimplePolygonDetection1 = 2 * numOfPoints1;
                                        boolean intersect = false;
                                        int middleVertex0 = numOfPoints0 - 1;
                                        int numOfTriangles1 = 0;
                                        int middleVertex1 = numOfPoints1 - 1;
                                        this.trianglesX1.reset();
                                        this.trianglesY1.reset();
                                        while ((middleVertex1 = this.triangulatePolygon(bytes1, offset1, numOfPoints1, this.pointsOffsets1, this.trianglesX1, this.trianglesY1, numOfTriangles1, nonSimplePolygonDetection1, middleVertex1)) != -1) {
                                            nonSimplePolygonDetection1 = 2 * --numOfPoints1;
                                            ++numOfTriangles1;
                                        }
                                        int numOfTriangles0 = 0;
                                        this.trianglesX0.reset();
                                        this.trianglesY0.reset();
                                        while ((middleVertex0 = this.triangulatePolygon(bytes0, offset0, numOfPoints0, this.pointsOffsets0, this.trianglesX0, this.trianglesY0, numOfTriangles0, nonSimplePolygonDetection0, middleVertex0)) != -1) {
                                            nonSimplePolygonDetection0 = 2 * --numOfPoints0;
                                            ++numOfTriangles0;
                                            int lastTriangle = this.trianglesX0.length() / 3 - 1;
                                            for (int i = 0; i < numOfTriangles1; ++i) {
                                                res = this.triangleTriangleIntersection(this.trianglesX0, this.trianglesY0, lastTriangle, this.trianglesX1, this.trianglesY1, i);
                                                if (!res || !(res = this.triangleTriangleIntersection(this.trianglesX1, this.trianglesY1, i, this.trianglesX0, this.trianglesY0, lastTriangle))) continue;
                                                intersect = true;
                                                break;
                                            }
                                            if (!intersect) continue;
                                            break block0;
                                        }
                                        break block0;
                                    }
                                    case CIRCLE: {
                                        res = this.polygonCircleIntersection(bytes0, offset0, bytes1, offset1);
                                        break block0;
                                    }
                                    case RECTANGLE: {
                                        res = this.rectanglePolygonIntersection(bytes1, offset1, bytes0, offset0);
                                        break block0;
                                    }
                                    default: {
                                        throw new TypeMismatchException(SpatialIntersectDescriptor.this.sourceLoc, SpatialIntersectDescriptor.this.getIdentifier(), 1, bytes1[offset1], ATypeTag.SERIALIZED_POINT_TYPE_TAG, ATypeTag.SERIALIZED_LINE_TYPE_TAG, ATypeTag.SERIALIZED_POLYGON_TYPE_TAG, ATypeTag.SERIALIZED_CIRCLE_TYPE_TAG, ATypeTag.SERIALIZED_RECTANGLE_TYPE_TAG);
                                    }
                                }
                            }
                            case CIRCLE: {
                                switch (tag1) {
                                    case POINT: {
                                        res = this.pointInCircle(bytes1, offset1, bytes0, offset0);
                                        break block0;
                                    }
                                    case LINE: {
                                        res = this.lineCircleIntersection(bytes1, offset1, bytes0, offset0);
                                        break block0;
                                    }
                                    case POLYGON: {
                                        res = this.polygonCircleIntersection(bytes1, offset1, bytes0, offset0);
                                        break block0;
                                    }
                                    case CIRCLE: {
                                        res = this.circleCircleIntersection(bytes0, offset0, bytes1, offset1);
                                        break block0;
                                    }
                                    case RECTANGLE: {
                                        res = this.rectangleCircleIntersection(bytes1, offset1, bytes0, offset0);
                                        break block0;
                                    }
                                }
                                throw new TypeMismatchException(SpatialIntersectDescriptor.this.sourceLoc, SpatialIntersectDescriptor.this.getIdentifier(), 1, bytes1[offset1], ATypeTag.SERIALIZED_POINT_TYPE_TAG, ATypeTag.SERIALIZED_LINE_TYPE_TAG, ATypeTag.SERIALIZED_POLYGON_TYPE_TAG, ATypeTag.SERIALIZED_CIRCLE_TYPE_TAG, ATypeTag.SERIALIZED_RECTANGLE_TYPE_TAG);
                            }
                            case RECTANGLE: {
                                switch (tag1) {
                                    case POINT: {
                                        res = this.pointInRectangle(bytes1, offset1, bytes0, offset0);
                                        break block0;
                                    }
                                    case LINE: {
                                        res = this.lineRectangleIntersection(bytes1, offset1, bytes0, offset0);
                                        break block0;
                                    }
                                    case POLYGON: {
                                        res = this.rectanglePolygonIntersection(bytes0, offset0, bytes1, offset1);
                                        break block0;
                                    }
                                    case CIRCLE: {
                                        res = this.rectangleCircleIntersection(bytes0, offset0, bytes1, offset1);
                                        break block0;
                                    }
                                    case RECTANGLE: {
                                        this.triangulateRectangle(bytes0, offset0, this.trianglesX0, this.trianglesY0);
                                        this.triangulateRectangle(bytes1, offset1, this.trianglesX1, this.trianglesY1);
                                        boolean intersect = false;
                                        for (int j = 0; j < 2; ++j) {
                                            for (int i = 0; i < 2; ++i) {
                                                res = this.triangleTriangleIntersection(this.trianglesX1, this.trianglesY1, i, this.trianglesX0, this.trianglesY0, j);
                                                if (!res || !(res = this.triangleTriangleIntersection(this.trianglesX0, this.trianglesY0, j, this.trianglesX1, this.trianglesY1, i))) continue;
                                                intersect = true;
                                                break;
                                            }
                                            if (intersect) break block0;
                                        }
                                        break block0;
                                    }
                                    default: {
                                        throw new TypeMismatchException(SpatialIntersectDescriptor.this.sourceLoc, SpatialIntersectDescriptor.this.getIdentifier(), 1, bytes1[offset1], ATypeTag.SERIALIZED_POINT_TYPE_TAG, ATypeTag.SERIALIZED_LINE_TYPE_TAG, ATypeTag.SERIALIZED_POLYGON_TYPE_TAG, ATypeTag.SERIALIZED_CIRCLE_TYPE_TAG, ATypeTag.SERIALIZED_RECTANGLE_TYPE_TAG);
                                    }
                                }
                            }
                            default: {
                                throw new TypeMismatchException(SpatialIntersectDescriptor.this.sourceLoc, SpatialIntersectDescriptor.this.getIdentifier(), 0, bytes0[offset0], ATypeTag.SERIALIZED_POINT_TYPE_TAG, ATypeTag.SERIALIZED_LINE_TYPE_TAG, ATypeTag.SERIALIZED_POLYGON_TYPE_TAG, ATypeTag.SERIALIZED_CIRCLE_TYPE_TAG, ATypeTag.SERIALIZED_RECTANGLE_TYPE_TAG);
                            }
                        }
                        ABoolean aResult = res ? ABoolean.TRUE : ABoolean.FALSE;
                        this.aBooleanSerDer.serialize((IAObject)aResult, this.out);
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.SPATIAL_INTERSECT;
    }
}

