/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.nonvisitor.ARecordPointable;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.asterix.runtime.evaluators.functions.CastTypeEvaluator;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class RecordValuesEvaluator
implements IScalarEvaluator {
    private final IPointable inputRecordPointable = new VoidPointable();
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput resultOutput = this.resultStorage.getDataOutput();
    private final IScalarEvaluator eval0;
    private final boolean inputRecordOpen;
    private final ARecordPointable recordPointable;
    private final ArrayBackedValueStorage fieldValueStorage;
    private OrderedListBuilder listBuilder;
    private ARecordVisitablePointable openRecordPointable;
    private CastTypeEvaluator inputRecordCaster;

    RecordValuesEvaluator(IScalarEvaluator eval0, ARecordType recordType) {
        this.eval0 = eval0;
        if (recordType != null) {
            this.inputRecordOpen = recordType.isOpen() && recordType.getFieldTypes().length == 0;
            this.openRecordPointable = new ARecordVisitablePointable(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
            this.inputRecordCaster = new CastTypeEvaluator((IAType)BuiltinType.ANY, (IAType)recordType, eval0);
            this.listBuilder = new OrderedListBuilder();
        } else {
            this.inputRecordOpen = true;
        }
        if (this.inputRecordOpen) {
            this.recordPointable = new ARecordPointable();
            this.fieldValueStorage = new ArrayBackedValueStorage();
        } else {
            this.recordPointable = null;
            this.fieldValueStorage = null;
        }
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.eval0.evaluate(tuple, this.inputRecordPointable);
        if (PointableHelper.checkAndSetMissingOrNull(result, this.inputRecordPointable)) {
            return;
        }
        ATypeTag inputTypeTag = PointableHelper.getTypeTag((IValueReference)this.inputRecordPointable);
        if (inputTypeTag != ATypeTag.OBJECT) {
            PointableHelper.setNull(result);
            return;
        }
        this.resultStorage.reset();
        if (this.inputRecordOpen) {
            this.buildOutputList();
        } else {
            this.buildOutputList(tuple);
        }
        result.set((IValueReference)this.resultStorage);
    }

    private void buildOutputList(IFrameTupleReference tuple) throws HyracksDataException {
        this.listBuilder.reset((AbstractCollectionType)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
        this.inputRecordCaster.evaluate(tuple, this.inputRecordPointable);
        this.openRecordPointable.set((IValueReference)this.inputRecordPointable);
        List fieldValues = this.openRecordPointable.getFieldValues();
        int valuesCount = fieldValues.size();
        for (int i = 0; i < valuesCount; ++i) {
            this.listBuilder.addItem((IValueReference)fieldValues.get(i));
        }
        this.listBuilder.write(this.resultOutput, true);
    }

    private void buildOutputList() throws HyracksDataException {
        this.listBuilder.reset((AbstractCollectionType)AOrderedListType.FULL_OPEN_ORDEREDLIST_TYPE);
        this.recordPointable.set((IValueReference)this.inputRecordPointable);
        int openFieldCount = this.recordPointable.getOpenFieldCount(RecordUtil.FULLY_OPEN_RECORD_TYPE);
        for (int i = 0; i < openFieldCount; ++i) {
            this.fieldValueStorage.reset();
            try {
                this.recordPointable.getOpenFieldValue(RecordUtil.FULLY_OPEN_RECORD_TYPE, i, this.fieldValueStorage.getDataOutput());
                this.listBuilder.addItem((IValueReference)this.fieldValueStorage);
                continue;
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
        this.listBuilder.write(this.resultOutput, true);
    }
}

