/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class MXHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    public static final List<GarbageCollectorMXBean> gcMXBeans = Collections.unmodifiableList(ManagementFactory.getGarbageCollectorMXBeans());
    public static final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    public static final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    public static final OperatingSystemMXBean osMXBean = ManagementFactory.getOperatingSystemMXBean();
    private static Method getOpenFileDescriptorCount;
    private static Method getMaxFileDescriptorCount;

    private MXHelper() {
    }

    public static boolean supportOpenFileCount() {
        return getOpenFileDescriptorCount != null;
    }

    public static long getCurrentOpenFileCount() {
        if (getOpenFileDescriptorCount == null) {
            return -1L;
        }
        try {
            return (Long)getOpenFileDescriptorCount.invoke((Object)osMXBean, new Object[0]);
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARN, "Failure invoking getOpenFileDescriptorCount", e);
            return -1L;
        }
    }

    public static long getMaxOpenFileCount() {
        if (getMaxFileDescriptorCount == null) {
            return -1L;
        }
        try {
            return (Long)getMaxFileDescriptorCount.invoke((Object)osMXBean, new Object[0]);
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARN, "Failure invoking getMaxFileDescriptorCount", e);
            return -1L;
        }
    }

    public static void logFileDescriptors() {
        try {
            if (MXHelper.supportOpenFileCount()) {
                LOGGER.log(Level.WARN, "Number of open files by this process is {}. Max number of allowed open files is {} ", new Supplier[]{MXHelper::getCurrentOpenFileCount, MXHelper::getMaxOpenFileCount});
            }
        }
        catch (Throwable th) {
            LOGGER.log(Level.WARN, "Failed getting the count of open files", th);
        }
    }

    public static String getBootClassPath() {
        try {
            return runtimeMXBean.isBootClassPathSupported() ? runtimeMXBean.getBootClassPath() : null;
        }
        catch (UnsupportedOperationException e) {
            LOGGER.debug("ignoring exception calling RuntimeMXBean.getBootClassPath; returning null", (Throwable)e);
            return null;
        }
    }

    static {
        if (SystemUtils.IS_OS_WINDOWS) {
            LOGGER.info("Access to file descriptors (FDs) is not available on Windows; FD info will not be logged");
        } else {
            Class<?> osMXBeanClass = osMXBean.getClass();
            try {
                getOpenFileDescriptorCount = osMXBeanClass.getMethod("getOpenFileDescriptorCount", new Class[0]);
                getMaxFileDescriptorCount = osMXBeanClass.getDeclaredMethod("getMaxFileDescriptorCount", new Class[0]);
                getOpenFileDescriptorCount.setAccessible(true);
                getMaxFileDescriptorCount.setAccessible(true);
            }
            catch (Throwable th) {
                getOpenFileDescriptorCount = null;
                getMaxFileDescriptorCount = null;
                LOGGER.warn("Failed setting up the methods to get the number of file descriptors through {}", (Object)osMXBeanClass.getName(), (Object)th);
            }
        }
    }
}

