/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library.msgpack;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.dataflow.data.nontagged.printers.PrintTools;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.external.library.PyTypeInfo;
import org.apache.asterix.external.library.msgpack.IMsgPackAccessor;
import org.apache.asterix.external.library.msgpack.MsgPackPointableVisitor;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.visitor.IVisitablePointableVisitor;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.util.encoding.VarLenIntEncoderDecoder;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class MsgPackAccessors {
    private MsgPackAccessors() {
    }

    public static IMsgPackAccessor<IPointable, DataOutput, Void> createFlatMsgPackAccessor(ATypeTag aTypeTag) throws HyracksDataException {
        switch (aTypeTag) {
            case BOOLEAN: {
                return MsgPackBooleanAccessor::apply;
            }
            case TINYINT: {
                return MsgPackInt8Accessor::apply;
            }
            case SMALLINT: {
                return MsgPackInt16Accessor::apply;
            }
            case INTEGER: {
                return MsgPackInt32Accessor::apply;
            }
            case BIGINT: {
                return MsgPackInt64Accessor::apply;
            }
            case FLOAT: {
                return MsgPackFloatAccessor::apply;
            }
            case DOUBLE: {
                return MsgPackDoubleAccessor::apply;
            }
            case STRING: {
                return MsgPackStringAccessor::apply;
            }
            case MISSING: 
            case NULL: {
                return MsgPackNullAccessor::apply;
            }
        }
        throw HyracksDataException.create((Throwable)AsterixException.create((ErrorCode)ErrorCode.TYPE_UNSUPPORTED, (Serializable[])new Serializable[]{"msgpack", aTypeTag.name()}));
    }

    public static class MsgPackListAccessor {
        public static Void access(AListVisitablePointable pointable, PyTypeInfo arg, MsgPackPointableVisitor pointableVisitor) throws HyracksDataException {
            List items = pointable.getItems();
            List itemTags = pointable.getItemTags();
            DataOutput out = arg.getDataOutput();
            try {
                out.writeByte(-35);
                out.writeInt(items.size());
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            for (int iter1 = 0; iter1 < items.size(); ++iter1) {
                IVisitablePointable itemPointable = (IVisitablePointable)items.get(iter1);
                IAType fieldType = ((AbstractCollectionType)arg.getType()).getItemType();
                if (fieldType.getTypeTag() == ATypeTag.ANY) {
                    IVisitablePointable itemTagPointable = (IVisitablePointable)itemTags.get(iter1);
                    ATypeTag itemTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(itemTagPointable.getByteArray()[itemTagPointable.getStartOffset()]);
                    fieldType = TypeTagUtil.getBuiltinTypeByTag((ATypeTag)itemTypeTag);
                }
                PyTypeInfo fieldTypeInfo = pointableVisitor.getTypeInfo(fieldType, out);
                itemPointable.accept((IVisitablePointableVisitor)pointableVisitor, (Object)fieldTypeInfo);
            }
            return null;
        }
    }

    public static class MsgPackRecordAccessor {
        public static int getUTFLength(byte[] b, int s) {
            return VarLenIntEncoderDecoder.decode((byte[])b, (int)s);
        }

        public static Void access(ARecordVisitablePointable pointable, PyTypeInfo arg, MsgPackPointableVisitor pointableVisitor) throws HyracksDataException {
            List fieldPointables = pointable.getFieldValues();
            List fieldTypeTags = pointable.getFieldTypeTags();
            List fieldNames = pointable.getFieldNames();
            int index = 0;
            DataOutput out = arg.getDataOutput();
            ARecordType recordType = (ARecordType)arg.getType();
            try {
                out.writeByte(-33);
                out.writeInt(fieldNames.size());
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            try {
                for (IVisitablePointable fieldPointable : fieldPointables) {
                    boolean closedPart = index < recordType.getFieldTypes().length;
                    IVisitablePointable tt = (IVisitablePointable)fieldTypeTags.get(index);
                    ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(tt.getByteArray()[tt.getStartOffset()]);
                    IAType fieldType = closedPart ? recordType.getFieldTypes()[index] : TypeTagUtil.getBuiltinTypeByTag((ATypeTag)typeTag);
                    IPointable fieldName = (IPointable)fieldNames.get(index);
                    MsgPackAccessors.createFlatMsgPackAccessor(BuiltinType.ASTRING.getTypeTag()).apply(fieldName, arg.getDataOutput());
                    PyTypeInfo fieldTypeInfo = pointableVisitor.getTypeInfo(fieldType, out);
                    fieldPointable.accept((IVisitablePointableVisitor)pointableVisitor, (Object)fieldTypeInfo);
                    ++index;
                }
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            return null;
        }
    }

    public static class MsgPackBooleanAccessor {
        public static Void apply(IPointable pointable, DataOutput out) throws IOException {
            int s;
            byte[] b = pointable.getByteArray();
            boolean v = ABooleanSerializerDeserializer.getBoolean((byte[])b, (int)((s = pointable.getStartOffset()) + 1));
            if (v) {
                out.writeByte(-61);
            } else {
                out.writeByte(-62);
            }
            return null;
        }
    }

    public static class MsgPackStringAccessor {
        public static Void apply(IPointable pointable, DataOutput out) throws IOException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            out.writeByte(-37);
            int calculatedLength = UTF8StringUtil.getUTFLength((byte[])b, (int)(s + 1));
            out.writeInt(calculatedLength);
            PrintTools.writeUTF8StringRaw((byte[])b, (int)(s + 1), (int)calculatedLength, (DataOutput)out);
            return null;
        }
    }

    public static class MsgPackDoubleAccessor {
        public static Void apply(IPointable pointable, DataOutput out) throws IOException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            double v = ADoubleSerializerDeserializer.getDouble((byte[])b, (int)(s + 1));
            out.writeByte(-53);
            out.writeDouble(v);
            return null;
        }
    }

    public static class MsgPackFloatAccessor {
        public static Void apply(IPointable pointable, DataOutput out) throws IOException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            float v = AFloatSerializerDeserializer.getFloat((byte[])b, (int)(s + 1));
            out.writeByte(-54);
            out.writeFloat(v);
            return null;
        }
    }

    public static class MsgPackInt64Accessor {
        public static Void apply(IPointable pointable, DataOutput out) throws IOException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            long v = AInt64SerializerDeserializer.getLong((byte[])b, (int)(s + 1));
            out.writeByte(-45);
            out.writeLong(v);
            return null;
        }
    }

    public static class MsgPackNullAccessor {
        public static Void apply(IPointable pointable, DataOutput out) throws IOException {
            out.writeByte(-64);
            return null;
        }
    }

    public static class MsgPackInt32Accessor {
        public static Void apply(IPointable pointable, DataOutput out) throws IOException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            int i = AInt32SerializerDeserializer.getInt((byte[])b, (int)(s + 1));
            out.writeByte(-46);
            out.writeInt(i);
            return null;
        }
    }

    public static class MsgPackInt16Accessor {
        public static Void apply(IPointable pointable, DataOutput out) throws IOException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            short i = AInt16SerializerDeserializer.getShort((byte[])b, (int)(s + 1));
            out.writeByte(-47);
            out.writeShort(i);
            return null;
        }
    }

    public static class MsgPackInt8Accessor {
        public static Void apply(IPointable pointable, DataOutput out) throws IOException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            byte o = AInt8SerializerDeserializer.getByte((byte[])b, (int)(s + 1));
            out.writeByte(-48);
            out.writeByte(o);
            return null;
        }
    }
}

