/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.security;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.DtFetcher;
import org.apache.hadoop.security.token.Token;

public class AbfsDtFetcher
implements DtFetcher {
    private static final String FETCH_FAILED = "Filesystem not generating Delegation Tokens";

    public Text getServiceName() {
        return new Text(this.getScheme());
    }

    protected String getScheme() {
        return "abfs";
    }

    public boolean isTokenRequired() {
        return UserGroupInformation.isSecurityEnabled();
    }

    public Token<?> addDelegationTokens(Configuration conf, Credentials creds, String renewer, String url) throws Exception {
        FileSystem fs;
        Token token;
        if (!url.startsWith(this.getServiceName().toString())) {
            url = this.getServiceName().toString() + "://" + url;
        }
        if ((token = (fs = FileSystem.get((URI)URI.create(url), (Configuration)conf)).getDelegationToken(renewer)) == null) {
            throw new IOException("Filesystem not generating Delegation Tokens: " + url);
        }
        creds.addToken(token.getService(), token);
        return token;
    }
}

