/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.result.IResultSet;
import org.apache.hyracks.http.api.IServletRequest;

public class ServletUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IResultSet getResultSet(IApplicationContext appCtx, Map<String, Object> ctx) throws Exception {
        IResultSet resultSet = (IResultSet)ctx.get("org.apache.asterix.RESULTSET");
        if (resultSet == null) {
            Map<String, Object> map = ctx;
            synchronized (map) {
                resultSet = (IResultSet)ctx.get("org.apache.asterix.RESULTSET");
                if (resultSet == null) {
                    resultSet = appCtx.getResultSet();
                    ctx.put("org.apache.asterix.RESULTSET", resultSet);
                }
            }
        }
        return resultSet;
    }

    public static DataverseName getDataverseName(IServletRequest request, String dataverseParameterName) throws AlgebricksException {
        List values = request.getParameterValues((CharSequence)dataverseParameterName);
        return !values.isEmpty() ? DataverseName.create((List)values) : null;
    }

    public static String decodeUriSegment(String uriSegment) {
        try {
            return new String(URLCodec.decodeUrl((byte[])uriSegment.getBytes(StandardCharsets.US_ASCII)), StandardCharsets.UTF_8);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

