/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dynamodbv2.model.ImportTableRequest;
import com.amazonaws.util.IdempotentUtils;

@SdkInternalApi
public class ImportTableRequestMarshaller {
    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientToken").defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<StructuredPojo> S3BUCKETSOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3BucketSource").build();
    private static final MarshallingInfo<String> INPUTFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputFormat").build();
    private static final MarshallingInfo<StructuredPojo> INPUTFORMATOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputFormatOptions").build();
    private static final MarshallingInfo<String> INPUTCOMPRESSIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InputCompressionType").build();
    private static final MarshallingInfo<StructuredPojo> TABLECREATIONPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableCreationParameters").build();
    private static final ImportTableRequestMarshaller instance = new ImportTableRequestMarshaller();

    public static ImportTableRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImportTableRequest importTableRequest, ProtocolMarshaller protocolMarshaller) {
        if (importTableRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)importTableRequest.getClientToken(), CLIENTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)importTableRequest.getS3BucketSource(), S3BUCKETSOURCE_BINDING);
            protocolMarshaller.marshall((Object)importTableRequest.getInputFormat(), INPUTFORMAT_BINDING);
            protocolMarshaller.marshall((Object)importTableRequest.getInputFormatOptions(), INPUTFORMATOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)importTableRequest.getInputCompressionType(), INPUTCOMPRESSIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)importTableRequest.getTableCreationParameters(), TABLECREATIONPARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

