/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.io.Serializable;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SwitchOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class SweepIllegalNonfunctionalFunctions
implements IAlgebraicRewriteRule {
    private final IllegalNonfunctionalFunctionSweeperOperatorVisitor visitor = new IllegalNonfunctionalFunctionSweeperOperatorVisitor();

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator op = (ILogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, op)) {
            return false;
        }
        op.accept((ILogicalOperatorVisitor)this.visitor, null);
        context.computeAndSetTypeEnvironmentForOperator(op);
        context.addToDontApplySet((IAlgebraicRewriteRule)this, op);
        return false;
    }

    private class IllegalNonfunctionalFunctionSweeperOperatorVisitor
    implements ILogicalOperatorVisitor<Void, Void> {
        private IllegalNonfunctionalFunctionSweeperOperatorVisitor() {
        }

        private void sweepExpression(ILogicalExpression expr) throws AlgebricksException {
            if (expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && !expr.isFunctional()) {
                AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)expr;
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, fce.getSourceLocation(), new Serializable[]{"Found non-functional function " + fce.getFunctionIdentifier()});
            }
        }

        public Void visitAggregateOperator(AggregateOperator op, Void arg) throws AlgebricksException {
            for (Mutable me : op.getExpressions()) {
                this.sweepExpression((ILogicalExpression)me.getValue());
            }
            List mergeExprs = op.getMergeExpressions();
            if (mergeExprs != null) {
                for (Mutable me : mergeExprs) {
                    this.sweepExpression((ILogicalExpression)me.getValue());
                }
            }
            return null;
        }

        public Void visitRunningAggregateOperator(RunningAggregateOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitGroupByOperator(GroupByOperator op, Void arg) throws AlgebricksException {
            for (Pair p : op.getGroupByList()) {
                this.sweepExpression((ILogicalExpression)((Mutable)p.second).getValue());
            }
            for (Pair p : op.getDecorList()) {
                this.sweepExpression((ILogicalExpression)((Mutable)p.second).getValue());
            }
            return null;
        }

        public Void visitLimitOperator(LimitOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitInnerJoinOperator(InnerJoinOperator op, Void arg) throws AlgebricksException {
            this.sweepExpression((ILogicalExpression)op.getCondition().getValue());
            return null;
        }

        public Void visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Void arg) throws AlgebricksException {
            this.sweepExpression((ILogicalExpression)op.getCondition().getValue());
            return null;
        }

        public Void visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitOrderOperator(OrderOperator op, Void arg) throws AlgebricksException {
            for (Pair p : op.getOrderExpressions()) {
                this.sweepExpression((ILogicalExpression)((Mutable)p.second).getValue());
            }
            return null;
        }

        public Void visitAssignOperator(AssignOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitSelectOperator(SelectOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitDelegateOperator(DelegateOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitProjectOperator(ProjectOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitReplicateOperator(ReplicateOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitSplitOperator(SplitOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitSwitchOperator(SwitchOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitMaterializeOperator(MaterializeOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitScriptOperator(ScriptOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitSubplanOperator(SubplanOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitSinkOperator(SinkOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitUnionOperator(UnionAllOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitIntersectOperator(IntersectOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitUnnestOperator(UnnestOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitUnnestMapOperator(UnnestMapOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitDataScanOperator(DataSourceScanOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitDistinctOperator(DistinctOperator op, Void arg) throws AlgebricksException {
            for (Mutable expr : op.getExpressions()) {
                this.sweepExpression((ILogicalExpression)expr.getValue());
            }
            return null;
        }

        public Void visitExchangeOperator(ExchangeOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitWriteOperator(WriteOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitDistributeResultOperator(DistributeResultOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitWriteResultOperator(WriteResultOperator op, Void arg) throws AlgebricksException {
            return null;
        }

        public Void visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, Void tag) throws AlgebricksException {
            return null;
        }

        public Void visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, Void tag) throws AlgebricksException {
            return null;
        }

        public Void visitTokenizeOperator(TokenizeOperator op, Void tag) throws AlgebricksException {
            return null;
        }

        public Void visitForwardOperator(ForwardOperator op, Void arg) throws AlgebricksException {
            this.sweepExpression((ILogicalExpression)op.getSideDataExpression().getValue());
            return null;
        }

        public Void visitWindowOperator(WindowOperator op, Void arg) throws AlgebricksException {
            ILogicalExpression frameOffsetExpr;
            for (Mutable me : op.getPartitionExpressions()) {
                this.sweepExpression((ILogicalExpression)me.getValue());
            }
            for (Pair p : op.getOrderExpressions()) {
                this.sweepExpression((ILogicalExpression)((Mutable)p.second).getValue());
            }
            for (Pair p : op.getFrameValueExpressions()) {
                this.sweepExpression((ILogicalExpression)((Mutable)p.second).getValue());
            }
            for (Mutable me : op.getFrameStartExpressions()) {
                this.sweepExpression((ILogicalExpression)me.getValue());
            }
            for (Mutable me : op.getFrameStartValidationExpressions()) {
                this.sweepExpression((ILogicalExpression)me.getValue());
            }
            for (Mutable me : op.getFrameEndExpressions()) {
                this.sweepExpression((ILogicalExpression)me.getValue());
            }
            for (Mutable me : op.getFrameEndValidationExpressions()) {
                this.sweepExpression((ILogicalExpression)me.getValue());
            }
            for (Mutable me : op.getFrameExcludeExpressions()) {
                this.sweepExpression((ILogicalExpression)me.getValue());
            }
            ILogicalExpression frameExcludeUnaryExpr = (ILogicalExpression)op.getFrameExcludeUnaryExpression().getValue();
            if (frameExcludeUnaryExpr != null) {
                this.sweepExpression(frameExcludeUnaryExpr);
            }
            if ((frameOffsetExpr = (ILogicalExpression)op.getFrameOffsetExpression().getValue()) != null) {
                this.sweepExpression(frameOffsetExpr);
            }
            for (Mutable me : op.getExpressions()) {
                ILogicalExpression expr = (ILogicalExpression)me.getValue();
                if (this.isStatefulFunctionCall(expr)) {
                    for (Mutable fcallArg : ((AbstractFunctionCallExpression)expr).getArguments()) {
                        this.sweepExpression((ILogicalExpression)fcallArg.getValue());
                    }
                    continue;
                }
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, op.getSourceLocation(), new Serializable[0]);
            }
            return null;
        }

        private boolean isStatefulFunctionCall(ILogicalExpression expr) {
            return expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && ((AbstractFunctionCallExpression)expr).getKind() == AbstractFunctionCallExpression.FunctionKind.STATEFUL;
        }
    }
}

