/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizer;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.ITokenFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.NGramUTF8StringBinaryTokenizer;

public class NGramUTF8StringBinaryTokenizerFactory
implements IBinaryTokenizerFactory {
    private static final long serialVersionUID = 1L;
    private final int gramLength;
    private final boolean usePrePost;
    private final boolean ignoreTokenCount;
    private final boolean sourceHasTypeTag;
    private final ITokenFactory tokenFactory;

    public NGramUTF8StringBinaryTokenizerFactory(int gramLength, boolean usePrePost, boolean ignoreTokenCount, boolean sourceHasTypeTag, ITokenFactory tokenFactory) {
        this.gramLength = gramLength;
        this.usePrePost = usePrePost;
        this.ignoreTokenCount = ignoreTokenCount;
        this.sourceHasTypeTag = sourceHasTypeTag;
        this.tokenFactory = tokenFactory;
    }

    @Override
    public IBinaryTokenizer createTokenizer() {
        return new NGramUTF8StringBinaryTokenizer(this.gramLength, this.usePrePost, this.ignoreTokenCount, this.sourceHasTypeTag, this.tokenFactory);
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode json = registry.getClassIdentifier(this.getClass(), 1L);
        json.set("tokenFactory", this.tokenFactory.toJson(registry));
        json.put("gramLength", this.gramLength);
        json.put("usePrePost", this.usePrePost);
        json.put("ignoreTokenCount", this.ignoreTokenCount);
        json.put("sourceHasTypeTag", this.sourceHasTypeTag);
        return json;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        ITokenFactory tokenFactory = (ITokenFactory)registry.deserialize(json.get("tokenFactory"));
        int gramLength = json.get("gramLength").asInt();
        boolean usePrePost = json.get("usePrePost").asBoolean();
        boolean ignoreTokenCount = json.get("ignoreTokenCount").asBoolean();
        boolean sourceHasTypeTag = json.get("sourceHasTypeTag").asBoolean();
        return new NGramUTF8StringBinaryTokenizerFactory(gramLength, usePrePost, ignoreTokenCount, sourceHasTypeTag, tokenFactory);
    }
}

