/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.pointables.nonvisitor;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.BytePointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.VarLengthTypeTrait;

public class AListPointable
extends AbstractPointable {
    public static final AListPointableFactory FACTORY = new AListPointableFactory();
    public static final IObjectFactory<IPointable, ATypeTag> ALLOCATOR = new IObjectFactory<IPointable, ATypeTag>(){

        @Override
        public IPointable create(ATypeTag type) {
            return new AListPointable();
        }
    };
    private static final int TAG_SIZE = 1;
    private static final int TYPE_SIZE = 1;
    private static final int LENGTH_SIZE = 4;
    private static final int ITEM_COUNT_SIZE = 4;
    private static final int ITEM_OFFSET_SIZE = 4;

    public byte getTag() {
        return BytePointable.getByte((byte[])this.bytes, (int)this.getTagOffset());
    }

    public int getTagOffset() {
        return this.start;
    }

    public int getTagSize() {
        return 1;
    }

    public byte getType() {
        return BytePointable.getByte((byte[])this.bytes, (int)this.getTypeOffset());
    }

    public int getTypeOffset() {
        return this.getTagOffset() + this.getTagSize();
    }

    public int getTypeSize() {
        return 1;
    }

    public boolean isTyped() {
        return this.getType() != ATypeTag.ANY.serialize();
    }

    public boolean isFixedType(AbstractCollectionType inputType) {
        return NonTaggedFormatUtil.isFixedSizedCollection(inputType.getItemType());
    }

    public int getFixedLength(AbstractCollectionType inputType) throws HyracksDataException {
        return NonTaggedFormatUtil.getFieldValueLength(this.bytes, 0, inputType.getItemType().getTypeTag(), false);
    }

    public boolean isOrdered(AbstractCollectionType inputType) {
        return inputType instanceof AOrderedListType;
    }

    public int getLength() {
        return IntegerPointable.getInteger((byte[])this.bytes, (int)this.getLengthOffset());
    }

    public int getLengthOffset() {
        return this.getTypeOffset() + this.getTypeSize();
    }

    public int getLengthSize() {
        return 4;
    }

    public int getItemCount() {
        return IntegerPointable.getInteger((byte[])this.bytes, (int)this.getItemCountOffset());
    }

    public int getItemCountOffset() {
        return this.getLengthOffset() + this.getLengthSize();
    }

    public int getItemCountSize() {
        return 4;
    }

    public int getItemOffset(AbstractCollectionType inputType, int index) throws HyracksDataException {
        if (this.isFixedType(inputType)) {
            return this.getItemCountOffset() + this.getItemCountSize() + index * this.getFixedLength(inputType);
        }
        int offset = this.getItemCountOffset() + this.getItemCountSize() + index * 4;
        return this.start + IntegerPointable.getInteger((byte[])this.bytes, (int)offset);
    }

    public byte getItemTag(AbstractCollectionType inputType, int index) throws HyracksDataException {
        if (this.getType() != ATypeTag.ANY.serialize()) {
            return this.getType();
        }
        return this.bytes[this.getItemOffset(inputType, index)];
    }

    public int getItemSize(AbstractCollectionType inputType, int index) throws HyracksDataException {
        if (this.isFixedType(inputType)) {
            return this.getFixedLength(inputType);
        }
        int nextOffset = this.getItemCount() > index + 1 ? this.getItemOffset(inputType, index + 1) : this.getLength();
        return nextOffset - this.getItemOffset(inputType, index);
    }

    public void getItemValue(AbstractCollectionType inputType, int index, DataOutput dOut) throws IOException {
        if (this.getType() != ATypeTag.ANY.serialize()) {
            dOut.writeByte(this.getType());
        }
        dOut.write(this.bytes, this.getItemOffset(inputType, index), this.getItemSize(inputType, index));
    }

    public static final class AListPointableFactory
    implements IPointableFactory {
        private static final long serialVersionUID = 1L;

        private AListPointableFactory() {
        }

        public AListPointable createPointable() {
            return new AListPointable();
        }

        public ITypeTraits getTypeTraits() {
            return VarLengthTypeTrait.INSTANCE;
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
            return registry.getClassIdentifier(this.getClass(), 1L);
        }

        public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
            return FACTORY;
        }
    }
}

