/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.util.List;
import java.util.function.Predicate;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.IFrameTupleProcessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class LSMTreeIndexAccessor
implements ILSMIndexAccessor {
    protected final ILSMHarness lsmHarness;
    protected final ILSMIndexOperationContext ctx;
    protected final ICursorFactory cursorFactory;
    private boolean destroyed = false;

    public LSMTreeIndexAccessor(ILSMHarness lsmHarness, ILSMIndexOperationContext ctx, ICursorFactory cursorFactory) {
        this.lsmHarness = lsmHarness;
        this.ctx = ctx;
        this.cursorFactory = cursorFactory;
    }

    public ILSMIndexOperationContext getCtx() {
        return this.ctx;
    }

    public void insert(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.INSERT);
        this.lsmHarness.modify(this.ctx, false, tuple);
    }

    public void update(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.UPDATE);
        this.lsmHarness.modify(this.ctx, false, tuple);
    }

    public void delete(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.DELETE);
        this.lsmHarness.modify(this.ctx, false, tuple);
    }

    public void upsert(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.UPSERT);
        this.lsmHarness.modify(this.ctx, false, tuple);
    }

    @Override
    public boolean tryInsert(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.INSERT);
        return this.lsmHarness.modify(this.ctx, true, tuple);
    }

    @Override
    public boolean tryDelete(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.DELETE);
        return this.lsmHarness.modify(this.ctx, true, tuple);
    }

    @Override
    public boolean tryUpdate(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.UPDATE);
        return this.lsmHarness.modify(this.ctx, true, tuple);
    }

    @Override
    public boolean tryUpsert(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.UPSERT);
        return this.lsmHarness.modify(this.ctx, true, tuple);
    }

    public void search(IIndexCursor cursor, ISearchPredicate searchPred) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.SEARCH);
        this.lsmHarness.search(this.ctx, cursor, searchPred);
    }

    @Override
    public void flush(ILSMIOOperation operation) throws HyracksDataException {
        this.lsmHarness.flush(operation);
    }

    @Override
    public void merge(ILSMIOOperation operation) throws HyracksDataException {
        this.lsmHarness.merge(operation);
    }

    @Override
    public void physicalDelete(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.PHYSICALDELETE);
        this.lsmHarness.modify(this.ctx, false, tuple);
    }

    @Override
    public ILSMIOOperation scheduleFlush() throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.FLUSH);
        return this.lsmHarness.scheduleFlush(this.ctx);
    }

    @Override
    public ILSMIOOperation scheduleMerge(List<ILSMDiskComponent> components) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.MERGE);
        this.ctx.getComponentsToBeMerged().clear();
        this.ctx.getComponentsToBeMerged().addAll(components);
        return this.lsmHarness.scheduleMerge(this.ctx);
    }

    @Override
    public void scheduleReplication(List<ILSMDiskComponent> lsmComponents, LSMOperationType opType) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.REPLICATE);
        this.ctx.getComponentsToBeReplicated().clear();
        this.ctx.getComponentsToBeReplicated().addAll(lsmComponents);
        this.lsmHarness.scheduleReplication(this.ctx, lsmComponents, opType);
    }

    @Override
    public ILSMIOOperation scheduleFullMerge() throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.FULL_MERGE);
        return this.lsmHarness.scheduleFullMerge(this.ctx);
    }

    @Override
    public void forcePhysicalDelete(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.PHYSICALDELETE);
        this.lsmHarness.forceModify(this.ctx, tuple);
    }

    @Override
    public void forceInsert(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.INSERT);
        this.lsmHarness.forceModify(this.ctx, tuple);
    }

    @Override
    public void forceUpsert(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.UPSERT);
        this.lsmHarness.forceModify(this.ctx, tuple);
    }

    @Override
    public void forceDelete(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.DELETE);
        this.lsmHarness.forceModify(this.ctx, tuple);
    }

    @Override
    public void updateMeta(IValueReference key, IValueReference value) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.UPSERT);
        this.lsmHarness.updateMeta(this.ctx, key, value);
    }

    @Override
    public void forceUpdateMeta(IValueReference key, IValueReference value) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.UPSERT);
        this.lsmHarness.forceUpdateMeta(this.ctx, key, value);
    }

    public IIndexCursor createSearchCursor(boolean exclusive) {
        return this.cursorFactory.create(this.ctx);
    }

    @Override
    public void updateFilter(ITupleReference tuple) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.UPSERT);
        this.lsmHarness.updateFilter(this.ctx, tuple);
    }

    public void batchOperate(FrameTupleAccessor accessor, FrameTupleReference tuple, IFrameTupleProcessor processor, IFrameOperationCallback frameOpCallback) throws HyracksDataException {
        this.lsmHarness.batchOperate(this.ctx, accessor, tuple, processor, frameOpCallback);
    }

    @Override
    public void scanDiskComponents(IIndexCursor cursor) throws HyracksDataException {
        this.ctx.setOperation(IndexOperation.DISK_COMPONENT_SCAN);
        this.lsmHarness.scanDiskComponents(this.ctx, cursor);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.lsmHarness.toString();
    }

    @Override
    public void deleteComponents(Predicate<ILSMComponent> predicate) throws HyracksDataException {
        this.lsmHarness.deleteComponents(this.ctx, predicate);
    }

    @Override
    public ILSMIndexOperationContext getOpContext() {
        return this.ctx;
    }

    public void destroy() throws HyracksDataException {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.ctx.destroy();
    }

    @FunctionalInterface
    public static interface ICursorFactory {
        public IIndexCursor create(ILSMIndexOperationContext var1);
    }
}

