/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.impl.ExecutingStoreOperation;
import org.apache.hadoop.fs.s3a.impl.StatusProbeEnum;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetContentSummaryOperation
extends ExecutingStoreOperation<ContentSummary>
implements IOStatisticsSource {
    private static final Logger LOG = LoggerFactory.getLogger(GetContentSummaryOperation.class);
    private final Path path;
    private final GetContentSummaryCallbacks callbacks;
    private final IOStatisticsSnapshot iostatistics = new IOStatisticsSnapshot();

    public GetContentSummaryOperation(StoreContext storeContext, Path path, GetContentSummaryCallbacks callbacks) {
        super(storeContext);
        this.path = path;
        this.callbacks = callbacks;
    }

    public IOStatistics getIOStatistics() {
        return this.iostatistics;
    }

    @Override
    public ContentSummary execute() throws IOException {
        S3AFileStatus status = this.probePathStatusOrNull(this.path, StatusProbeEnum.FILE);
        if (status != null && status.isFile()) {
            long length = status.getLen();
            return new ContentSummary.Builder().length(length).fileCount(1L).directoryCount(0L).spaceConsumed(length).build();
        }
        ContentSummary summary = this.getDirSummary(this.path);
        LOG.debug("IOStatistics of getContentSummary({}):\n{}", (Object)this.path, (Object)this.iostatistics);
        return summary;
    }

    public ContentSummary getDirSummary(Path dir) throws IOException {
        long totalLength = 0L;
        long fileCount = 0L;
        long dirCount = 1L;
        RemoteIterator<S3AFileStatus> it = this.callbacks.listStatusIterator(dir);
        while (it.hasNext()) {
            S3AFileStatus s = (S3AFileStatus)((Object)it.next());
            if (s.isDirectory()) {
                try {
                    ContentSummary c = this.getDirSummary(s.getPath());
                    totalLength += c.getLength();
                    fileCount += c.getFileCount();
                    dirCount += c.getDirectoryCount();
                }
                catch (FileNotFoundException fileNotFoundException) {}
                continue;
            }
            totalLength += s.getLen();
            ++fileCount;
        }
        this.iostatistics.aggregate(IOStatisticsSupport.retrieveIOStatistics(it));
        return new ContentSummary.Builder().length(totalLength).fileCount(fileCount).directoryCount(dirCount).spaceConsumed(totalLength).build();
    }

    private S3AFileStatus probePathStatusOrNull(Path p, Set<StatusProbeEnum> probes) throws IOException {
        try {
            return this.callbacks.probePathStatus(p, probes);
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    public static interface GetContentSummaryCallbacks {
        public S3AFileStatus probePathStatus(Path var1, Set<StatusProbeEnum> var2) throws IOException;

        public RemoteIterator<S3AFileStatus> listStatusIterator(Path var1) throws IOException;
    }
}

