/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ARecordSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AUnorderedListSerializerDeserializer;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.constructors.AbstractBooleanConstructorEvaluator;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.util.string.UTF8StringUtil;

@MissingNullInOutFunction
public class ToBooleanDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = ToBooleanDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new AbstractBooleanConstructorEvaluator(ctx, args[0].createScalarEvaluator(ctx), ToBooleanDescriptor.this.sourceLoc){

                    @Override
                    protected void handleUnsupportedType(ATypeTag inputType, IPointable result) throws HyracksDataException {
                        byte[] bytes = this.inputArg.getByteArray();
                        int startOffset = this.inputArg.getStartOffset();
                        int len = this.inputArg.getLength();
                        switch (inputType) {
                            case ARRAY: {
                                int n = AOrderedListSerializerDeserializer.getNumberOfItems((byte[])bytes, (int)startOffset);
                                this.setInteger(n, result);
                                break;
                            }
                            case MULTISET: {
                                int n = AUnorderedListSerializerDeserializer.getNumberOfItems((byte[])bytes, (int)startOffset);
                                this.setInteger(n, result);
                                break;
                            }
                            case OBJECT: {
                                boolean empty = ARecordSerializerDeserializer.hasNoFields((byte[])bytes, (int)startOffset, (int)len);
                                this.setBoolean(result, !empty);
                                break;
                            }
                            default: {
                                super.handleUnsupportedType(inputType, result);
                            }
                        }
                    }

                    @Override
                    protected Boolean parseBoolean(byte[] bytes, int offset, int len) {
                        return UTF8StringUtil.getStringLength((byte[])bytes, (int)(offset + 1)) != 0;
                    }

                    @Override
                    protected FunctionIdentifier getIdentifier() {
                        return ToBooleanDescriptor.this.getIdentifier();
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.TO_BOOLEAN;
    }
}

