/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.MetadataCache;
import org.apache.asterix.metadata.api.IMetadataEntity;
import org.apache.asterix.metadata.entities.DependencyKind;
import org.apache.asterix.om.types.TypeSignature;
import org.apache.hyracks.algebricks.common.utils.Triple;

public class Function
implements IMetadataEntity<Function> {
    private static final long serialVersionUID = 4L;
    private final FunctionSignature signature;
    private final List<String> paramNames;
    private final List<TypeSignature> paramTypes;
    private final TypeSignature returnType;
    private final String body;
    private final String language;
    private final String kind;
    private final DataverseName libraryDataverseName;
    private final String libraryName;
    private final List<String> externalIdentifier;
    private final Boolean deterministic;
    private final Boolean nullCall;
    private final Map<String, String> resources;
    private final List<List<Triple<DataverseName, String, String>>> dependencies;
    public static List<DependencyKind> DEPENDENCIES_SCHEMA = Arrays.asList(DependencyKind.DATASET, DependencyKind.FUNCTION, DependencyKind.TYPE, DependencyKind.SYNONYM);

    public Function(FunctionSignature signature, List<String> paramNames, List<TypeSignature> paramTypes, TypeSignature returnType, String functionBody, String functionKind, String language, DataverseName libraryDataverseName, String libraryName, List<String> externalIdentifier, Boolean nullCall, Boolean deterministic, Map<String, String> resources, List<List<Triple<DataverseName, String, String>>> dependencies) {
        this.signature = signature;
        this.paramNames = paramNames;
        this.paramTypes = paramTypes;
        this.body = functionBody;
        this.returnType = returnType;
        this.language = language;
        this.kind = functionKind;
        this.libraryDataverseName = libraryDataverseName;
        this.libraryName = libraryName;
        this.externalIdentifier = externalIdentifier;
        this.nullCall = nullCall;
        this.deterministic = deterministic;
        this.resources = resources == null ? Collections.emptyMap() : resources;
        this.dependencies = dependencies == null ? Arrays.asList(Collections.emptyList(), Collections.emptyList(), Collections.emptyList()) : dependencies;
    }

    public FunctionSignature getSignature() {
        return this.signature;
    }

    public DataverseName getDataverseName() {
        return this.signature.getDataverseName();
    }

    public String getName() {
        return this.signature.getName();
    }

    public int getArity() {
        return this.signature.getArity();
    }

    public List<String> getParameterNames() {
        return this.paramNames;
    }

    public List<TypeSignature> getParameterTypes() {
        return this.paramTypes;
    }

    public TypeSignature getReturnType() {
        return this.returnType;
    }

    public String getFunctionBody() {
        return this.body;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getKind() {
        return this.kind;
    }

    public boolean isExternal() {
        return this.externalIdentifier != null;
    }

    public DataverseName getLibraryDataverseName() {
        return this.libraryDataverseName;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public List<String> getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public Boolean getNullCall() {
        return this.nullCall;
    }

    public Boolean getDeterministic() {
        return this.deterministic;
    }

    public Map<String, String> getResources() {
        return this.resources;
    }

    public List<List<Triple<DataverseName, String, String>>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Function addToCache(MetadataCache cache) {
        return cache.addFunctionIfNotExists(this);
    }

    @Override
    public Function dropFromCache(MetadataCache cache) {
        return cache.dropFunction(this);
    }

    public static List<List<Triple<DataverseName, String, String>>> createDependencies(List<Triple<DataverseName, String, String>> datasetDependencies, List<Triple<DataverseName, String, String>> functionDependencies, List<Triple<DataverseName, String, String>> typeDependencies, List<Triple<DataverseName, String, String>> synonymDependencies) {
        ArrayList<List<Triple<DataverseName, String, String>>> depList = new ArrayList<List<Triple<DataverseName, String, String>>>(DEPENDENCIES_SCHEMA.size());
        depList.add(datasetDependencies);
        depList.add(functionDependencies);
        depList.add(typeDependencies);
        if (!synonymDependencies.isEmpty()) {
            depList.add(synonymDependencies);
        }
        return depList;
    }
}

