/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.DataOutput;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.transactions.TxnId;
import org.apache.asterix.metadata.MetadataNode;
import org.apache.asterix.metadata.api.IMetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.AbstractComplexType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public abstract class AbstractDatatypeTupleTranslator<T>
extends AbstractTupleTranslator<T> {
    protected final MetadataNode metadataNode;
    protected final TxnId txnId;

    public AbstractDatatypeTupleTranslator(TxnId txnId, MetadataNode metadataNode, boolean getTuple, IMetadataIndex metadataIndex, int payloadTupleFieldIndex) {
        super(getTuple, metadataIndex, payloadTupleFieldIndex);
        this.txnId = txnId;
        this.metadataNode = metadataNode;
    }

    protected void writeDerivedTypeRecord(DataverseName dataverseName, AbstractComplexType derivedDatatype, DataOutput out, boolean isAnonymous) throws HyracksDataException {
        DerivedTypeTag tag;
        RecordBuilder derivedRecordBuilder = new RecordBuilder();
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        switch (derivedDatatype.getTypeTag()) {
            case ARRAY: {
                tag = DerivedTypeTag.ORDEREDLIST;
                break;
            }
            case MULTISET: {
                tag = DerivedTypeTag.UNORDEREDLIST;
                break;
            }
            case OBJECT: {
                tag = DerivedTypeTag.RECORD;
                break;
            }
            default: {
                throw new UnsupportedOperationException("No metadata record Type for " + derivedDatatype.getDisplayName());
            }
        }
        derivedRecordBuilder.reset(MetadataRecordTypes.DERIVEDTYPE_RECORDTYPE);
        fieldValue.reset();
        this.aString.setValue(tag.toString());
        this.stringSerde.serialize((Object)this.aString, fieldValue.getDataOutput());
        derivedRecordBuilder.addField(0, (IValueReference)fieldValue);
        fieldValue.reset();
        this.booleanSerde.serialize((Object)ABoolean.valueOf((boolean)isAnonymous), fieldValue.getDataOutput());
        derivedRecordBuilder.addField(1, (IValueReference)fieldValue);
        switch (tag) {
            case RECORD: {
                fieldValue.reset();
                this.writeRecordType(dataverseName, derivedDatatype, fieldValue.getDataOutput());
                derivedRecordBuilder.addField(2, (IValueReference)fieldValue);
                break;
            }
            case UNORDEREDLIST: {
                fieldValue.reset();
                this.writeCollectionType(dataverseName, derivedDatatype, fieldValue.getDataOutput());
                derivedRecordBuilder.addField(3, (IValueReference)fieldValue);
                break;
            }
            case ORDEREDLIST: {
                fieldValue.reset();
                this.writeCollectionType(dataverseName, derivedDatatype, fieldValue.getDataOutput());
                derivedRecordBuilder.addField(4, (IValueReference)fieldValue);
            }
        }
        derivedRecordBuilder.write(out, true);
    }

    private void writeCollectionType(DataverseName dataverseName, AbstractComplexType type, DataOutput out) throws HyracksDataException {
        AbstractCollectionType listType = (AbstractCollectionType)type;
        IAType itemType = listType.getItemType();
        if (itemType.getTypeTag().isDerivedType()) {
            this.handleNestedDerivedType(dataverseName, itemType.getTypeName(), (AbstractComplexType)itemType);
        }
        this.aString.setValue(listType.getItemType().getTypeName());
        this.stringSerde.serialize((Object)this.aString, out);
    }

    private void writeRecordType(DataverseName dataverseName, AbstractComplexType type, DataOutput out) throws HyracksDataException {
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        RecordBuilder recordRecordBuilder = new RecordBuilder();
        RecordBuilder fieldRecordBuilder = new RecordBuilder();
        ARecordType recType = (ARecordType)type;
        OrderedListBuilder listBuilder = new OrderedListBuilder();
        listBuilder.reset((AbstractCollectionType)new AOrderedListType((IAType)MetadataRecordTypes.FIELD_RECORDTYPE, null));
        int n = recType.getFieldNames().length;
        for (int i = 0; i < n; ++i) {
            IAType fieldType = recType.getFieldTypes()[i];
            boolean fieldIsNullable = false;
            boolean fieldIsMissable = false;
            if (fieldType.getTypeTag() == ATypeTag.UNION) {
                AUnionType fieldUnionType = (AUnionType)fieldType;
                fieldIsNullable = fieldUnionType.isNullableType();
                fieldIsMissable = fieldUnionType.isMissableType();
                fieldType = fieldUnionType.getActualType();
            }
            if (fieldType.getTypeTag().isDerivedType()) {
                this.handleNestedDerivedType(dataverseName, fieldType.getTypeName(), (AbstractComplexType)fieldType);
            }
            itemValue.reset();
            fieldRecordBuilder.reset(MetadataRecordTypes.FIELD_RECORDTYPE);
            fieldValue.reset();
            this.aString.setValue(recType.getFieldNames()[i]);
            this.stringSerde.serialize((Object)this.aString, fieldValue.getDataOutput());
            fieldRecordBuilder.addField(0, (IValueReference)fieldValue);
            fieldValue.reset();
            this.aString.setValue(fieldType.getTypeName());
            this.stringSerde.serialize((Object)this.aString, fieldValue.getDataOutput());
            fieldRecordBuilder.addField(1, (IValueReference)fieldValue);
            fieldValue.reset();
            this.booleanSerde.serialize((Object)ABoolean.valueOf((boolean)fieldIsNullable), fieldValue.getDataOutput());
            fieldRecordBuilder.addField(2, (IValueReference)fieldValue);
            this.fieldName.reset();
            this.aString.setValue("IsMissable");
            this.stringSerde.serialize((Object)this.aString, this.fieldName.getDataOutput());
            fieldValue.reset();
            this.booleanSerde.serialize((Object)ABoolean.valueOf((boolean)fieldIsMissable), fieldValue.getDataOutput());
            fieldRecordBuilder.addField((IValueReference)this.fieldName, (IValueReference)fieldValue);
            fieldRecordBuilder.write(itemValue.getDataOutput(), true);
            listBuilder.addItem((IValueReference)itemValue);
        }
        recordRecordBuilder.reset(MetadataRecordTypes.RECORD_RECORDTYPE);
        fieldValue.reset();
        this.booleanSerde.serialize((Object)ABoolean.valueOf((boolean)recType.isOpen()), fieldValue.getDataOutput());
        recordRecordBuilder.addField(0, (IValueReference)fieldValue);
        fieldValue.reset();
        listBuilder.write(fieldValue.getDataOutput(), true);
        recordRecordBuilder.addField(1, (IValueReference)fieldValue);
        recordRecordBuilder.write(out, true);
    }

    protected void handleNestedDerivedType(DataverseName dataverseName, String typeName, AbstractComplexType nestedType) throws HyracksDataException {
        block3: {
            try {
                this.metadataNode.addDatatype(this.txnId, new Datatype(dataverseName, typeName, (IAType)nestedType, true));
            }
            catch (AlgebricksException e) {
                if (!(e.getCause() instanceof HyracksDataException)) {
                    throw HyracksDataException.create((Throwable)e);
                }
                HyracksDataException hde = (HyracksDataException)e.getCause();
                if (hde.matches((IError)ErrorCode.DUPLICATE_KEY)) break block3;
                throw hde;
            }
        }
    }

    public static enum DerivedTypeTag {
        RECORD,
        UNORDEREDLIST,
        ORDEREDLIST;

    }
}

