/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.sync;

import java.io.IOException;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.replication.IPartitionReplica;
import org.apache.asterix.common.replication.IReplicationStrategy;
import org.apache.asterix.common.transactions.ICheckpointManager;
import org.apache.asterix.replication.api.PartitionReplica;
import org.apache.asterix.replication.messaging.CheckpointPartitionIndexesTask;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.asterix.replication.sync.ReplicaFilesSynchronizer;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplicaSynchronizer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final INcApplicationContext appCtx;
    private final PartitionReplica replica;

    public ReplicaSynchronizer(INcApplicationContext appCtx, PartitionReplica replica) {
        this.appCtx = appCtx;
        this.replica = replica;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(boolean register, boolean deltaRecovery) throws IOException {
        Object partitionLock;
        LOGGER.debug("starting replica sync process for replica {}", (Object)this.replica);
        Object object = partitionLock = this.appCtx.getReplicaManager().getPartitionSyncLock(this.replica.getIdentifier().getPartition());
        synchronized (object) {
            LOGGER.trace("acquired partition replica lock");
            ICheckpointManager checkpointManager = this.appCtx.getTransactionSubsystem().getCheckpointManager();
            try {
                checkpointManager.suspend();
                LOGGER.debug("starting replica files sync");
                this.syncFiles(deltaRecovery);
                LOGGER.debug("completed replica files sync");
                this.checkpointReplicaIndexes();
                LOGGER.debug("replica indexes checkpoint completed");
                if (register) {
                    LOGGER.debug("registering replica");
                    this.appCtx.getReplicationManager().register((IPartitionReplica)this.replica);
                    LOGGER.debug("replica registered");
                }
            }
            finally {
                checkpointManager.resume();
            }
        }
    }

    private void syncFiles(boolean deltaRecovery) throws IOException {
        ReplicaFilesSynchronizer fileSync = new ReplicaFilesSynchronizer(this.appCtx, this.replica, deltaRecovery);
        IReplicationStrategy replStrategy = this.appCtx.getReplicationManager().getReplicationStrategy();
        this.appCtx.getDatasetLifecycleManager().flushDataset(replStrategy, p -> p == this.replica.getIdentifier().getPartition());
        this.waitForReplicatedDatasetsIO();
        LOGGER.debug("flushed partition datasets");
        fileSync.sync();
    }

    private void checkpointReplicaIndexes() throws IOException {
        int partition = this.replica.getIdentifier().getPartition();
        String masterNode = this.appCtx.getReplicaManager().isPartitionOrigin(partition) ? this.appCtx.getServiceContext().getNodeId() : null;
        CheckpointPartitionIndexesTask task = new CheckpointPartitionIndexesTask(partition, this.getPartitionMaxComponentId(partition), masterNode);
        LOGGER.debug("asking replica to checkpoint indexes");
        ReplicationProtocol.sendTo(this.replica, task);
        ReplicationProtocol.waitForAck(this.replica);
    }

    private long getPartitionMaxComponentId(int partition) throws HyracksDataException {
        IReplicationStrategy replStrategy = this.appCtx.getReplicationManager().getReplicationStrategy();
        PersistentLocalResourceRepository localResourceRepository = (PersistentLocalResourceRepository)this.appCtx.getLocalResourceRepository();
        return localResourceRepository.getReplicatedIndexesMaxComponentId(partition, replStrategy);
    }

    private void waitForReplicatedDatasetsIO() throws HyracksDataException {
        IReplicationStrategy replStrategy = this.appCtx.getReplicationManager().getReplicationStrategy();
        this.appCtx.getDatasetLifecycleManager().waitForIO(replStrategy);
    }
}

