/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.base;

import java.util.BitSet;
import org.apache.hyracks.api.comm.IPartitionCollector;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractConnectorDescriptor;
import org.apache.hyracks.dataflow.std.collectors.NonDeterministicChannelReader;
import org.apache.hyracks.dataflow.std.collectors.NonDeterministicFrameReader;
import org.apache.hyracks.dataflow.std.collectors.PartitionCollector;

public abstract class AbstractMToNConnectorDescriptor
extends AbstractConnectorDescriptor {
    private static final long serialVersionUID = 1L;

    public AbstractMToNConnectorDescriptor(IConnectorDescriptorRegistry spec) {
        super(spec);
    }

    public void indicateTargetPartitions(int nProducerPartitions, int nConsumerPartitions, int producerIndex, BitSet targetBitmap) {
        targetBitmap.clear();
        targetBitmap.set(0, nConsumerPartitions);
    }

    public void indicateSourcePartitions(int nProducerPartitions, int nConsumerPartitions, int consumerIndex, BitSet sourceBitmap) {
        sourceBitmap.clear();
        sourceBitmap.set(0, nProducerPartitions);
    }

    public boolean allProducersToAllConsumers() {
        return true;
    }

    public IPartitionCollector createPartitionCollector(IHyracksTaskContext ctx, RecordDescriptor recordDesc, int index, int nProducerPartitions, int nConsumerPartitions) throws HyracksDataException {
        BitSet expectedPartitions = new BitSet(nProducerPartitions);
        expectedPartitions.set(0, nProducerPartitions);
        NonDeterministicChannelReader channelReader = new NonDeterministicChannelReader(nProducerPartitions, expectedPartitions);
        NonDeterministicFrameReader frameReader = new NonDeterministicFrameReader(channelReader);
        return new PartitionCollector(ctx, this.getConnectorId(), index, expectedPartitions, frameReader, channelReader);
    }
}

