/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.parsers;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParser;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;

public class BooleanParserFactory
implements IValueParserFactory {
    private static final long serialVersionUID = 1L;
    public static final IValueParserFactory INSTANCE = new BooleanParserFactory();

    private BooleanParserFactory() {
    }

    @Override
    public IValueParser createValueParser() {
        return BooleanParserFactory::parse;
    }

    public static boolean parse(char[] buffer, int start, int length, DataOutput out) throws HyracksDataException {
        char ch;
        int i;
        int end = start + length;
        for (i = start; i < end && ((ch = buffer[i]) == ' ' || ch == '\t' || ch == '\n' || ch == '\r' || ch == '\f'); ++i) {
        }
        int remainingLength = end - i;
        boolean gotBoolean = false;
        boolean booleanValue = false;
        if (!(remainingLength < 4 || (ch = buffer[i]) != 't' && ch != 'T' || (ch = buffer[i + 1]) != 'r' && ch != 'R' || (ch = buffer[i + 2]) != 'u' && ch != 'U' || (ch = buffer[i + 3]) != 'e' && ch != 'E')) {
            gotBoolean = true;
            booleanValue = true;
            i += 4;
        } else if (!(remainingLength < 5 || (ch = buffer[i]) != 'f' && ch != 'F' || (ch = buffer[i + 1]) != 'a' && ch != 'A' || (ch = buffer[i + 2]) != 'l' && ch != 'L' || (ch = buffer[i + 3]) != 's' && ch != 'S' || (ch = buffer[i + 4]) != 'e' && ch != 'E')) {
            gotBoolean = true;
            booleanValue = false;
            i += 5;
        }
        while (i < end) {
            ch = buffer[i];
            if (ch != ' ' && ch != '\t' && ch != '\n' && ch != '\r' && ch != '\f') {
                return false;
            }
            ++i;
        }
        if (!gotBoolean) {
            return false;
        }
        try {
            out.writeBoolean(booleanValue);
            return true;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

