/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort;

import java.util.List;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.common.io.GeneratedRunFileReader;
import org.apache.hyracks.dataflow.std.buffermanager.EnumFreeSlotPolicy;
import org.apache.hyracks.dataflow.std.sort.AbstractExternalSortRunMerger;
import org.apache.hyracks.dataflow.std.sort.AbstractSorterOperatorDescriptor;
import org.apache.hyracks.dataflow.std.sort.Algorithm;
import org.apache.hyracks.dataflow.std.sort.ExternalSortRunGenerator;
import org.apache.hyracks.dataflow.std.sort.ExternalSortRunMerger;
import org.apache.hyracks.dataflow.std.sort.IRunGenerator;

public class ExternalSortOperatorDescriptor
extends AbstractSorterOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private Algorithm alg;
    private EnumFreeSlotPolicy policy;
    private final int outputLimit;

    public ExternalSortOperatorDescriptor(IOperatorDescriptorRegistry spec, int framesLimit, int[] sortFields, INormalizedKeyComputerFactory[] keyNormalizerFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, Algorithm alg) {
        this(spec, framesLimit, sortFields, keyNormalizerFactories, comparatorFactories, recordDescriptor, alg, EnumFreeSlotPolicy.LAST_FIT);
    }

    public ExternalSortOperatorDescriptor(IOperatorDescriptorRegistry spec, int framesLimit, int[] sortFields, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) {
        this(spec, framesLimit, sortFields, (INormalizedKeyComputerFactory[])null, comparatorFactories, recordDescriptor);
    }

    public ExternalSortOperatorDescriptor(IOperatorDescriptorRegistry spec, int framesLimit, int[] sortFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) {
        INormalizedKeyComputerFactory[] iNormalizedKeyComputerFactoryArray;
        if (firstKeyNormalizerFactory != null) {
            INormalizedKeyComputerFactory[] iNormalizedKeyComputerFactoryArray2 = new INormalizedKeyComputerFactory[1];
            iNormalizedKeyComputerFactoryArray = iNormalizedKeyComputerFactoryArray2;
            iNormalizedKeyComputerFactoryArray2[0] = firstKeyNormalizerFactory;
        } else {
            iNormalizedKeyComputerFactoryArray = null;
        }
        this(spec, framesLimit, sortFields, iNormalizedKeyComputerFactoryArray, comparatorFactories, recordDescriptor, Algorithm.MERGE_SORT, EnumFreeSlotPolicy.LAST_FIT);
    }

    public ExternalSortOperatorDescriptor(IOperatorDescriptorRegistry spec, int framesLimit, int[] sortFields, INormalizedKeyComputerFactory[] keyNormalizerFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) {
        this(spec, framesLimit, sortFields, keyNormalizerFactories, comparatorFactories, recordDescriptor, Algorithm.MERGE_SORT, EnumFreeSlotPolicy.LAST_FIT);
    }

    @Override
    public AbstractSorterOperatorDescriptor.SortActivity getSortActivity(ActivityId id) {
        return new AbstractSorterOperatorDescriptor.SortActivity(id){
            private static final long serialVersionUID = 1L;

            @Override
            protected IRunGenerator getRunGenerator(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider) throws HyracksDataException {
                ExternalSortRunGenerator runGen = new ExternalSortRunGenerator(ctx, ExternalSortOperatorDescriptor.this.sortFields, ExternalSortOperatorDescriptor.this.keyNormalizerFactories, ExternalSortOperatorDescriptor.this.comparatorFactories, ExternalSortOperatorDescriptor.this.outRecDescs[0], ExternalSortOperatorDescriptor.this.alg, ExternalSortOperatorDescriptor.this.policy, ExternalSortOperatorDescriptor.this.framesLimit, ExternalSortOperatorDescriptor.this.outputLimit);
                return runGen;
            }
        };
    }

    @Override
    public AbstractSorterOperatorDescriptor.MergeActivity getMergeActivity(ActivityId id) {
        return new AbstractSorterOperatorDescriptor.MergeActivity(id){
            private static final long serialVersionUID = 1L;

            @Override
            protected AbstractExternalSortRunMerger getSortRunMerger(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, List<GeneratedRunFileReader> runs, IBinaryComparator[] comparators, INormalizedKeyComputer nmkComputer, int necessaryFrames) {
                return new ExternalSortRunMerger(ctx, runs, ExternalSortOperatorDescriptor.this.sortFields, comparators, nmkComputer, ExternalSortOperatorDescriptor.this.outRecDescs[0], necessaryFrames, ExternalSortOperatorDescriptor.this.outputLimit);
            }
        };
    }

    public ExternalSortOperatorDescriptor(IOperatorDescriptorRegistry spec, int framesLimit, int[] sortFields, INormalizedKeyComputerFactory[] keyNormalizerFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, Algorithm alg, EnumFreeSlotPolicy policy) {
        this(spec, framesLimit, sortFields, keyNormalizerFactories, comparatorFactories, recordDescriptor, alg, policy, Integer.MAX_VALUE);
    }

    public ExternalSortOperatorDescriptor(IOperatorDescriptorRegistry spec, int framesLimit, int[] sortFields, INormalizedKeyComputerFactory[] keyNormalizerFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor, Algorithm alg, EnumFreeSlotPolicy policy, int outputLimit) {
        super(spec, framesLimit, sortFields, keyNormalizerFactories, comparatorFactories, recordDescriptor);
        this.alg = Algorithm.MERGE_SORT;
        this.policy = EnumFreeSlotPolicy.LAST_FIT;
        if (framesLimit <= 1) {
            throw new IllegalStateException();
        }
        this.alg = alg;
        this.policy = policy;
        this.outputLimit = outputLimit;
    }
}

