/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.function.Consumer;

final class Buffers {
    private Buffers() {
    }

    static void clear(Buffer b) {
        b.clear();
    }

    static void flip(Buffer b) {
        b.flip();
    }

    static void limit(Buffer b, int limit) {
        b.limit(limit);
    }

    static void position(Buffer b, int position) {
        b.position(position);
    }

    static int position(Buffer b) {
        return b.position();
    }

    static long copy(ByteBuffer content, ByteBuffer[] dsts) {
        return Buffers.copy(content, dsts, 0, dsts.length);
    }

    static long copy(ByteBuffer content, ByteBuffer[] dsts, int offset, int length) {
        int contentRemaining;
        long total = 0L;
        for (int i = offset; i < length && (contentRemaining = content.remaining()) > 0; ++i) {
            ByteBuffer buf = dsts[i];
            int bufRemaining = buf.remaining();
            if (bufRemaining == 0) continue;
            if (bufRemaining < contentRemaining) {
                Buffers.sliceAndConsume(content, bufRemaining, buf::put);
            } else {
                buf.put(content);
            }
            int written = bufRemaining - buf.remaining();
            total += (long)written;
        }
        return total;
    }

    static void sliceAndConsume(ByteBuffer src, int limit, Consumer<ByteBuffer> c) {
        ByteBuffer slice = src.slice();
        slice.limit(limit);
        c.accept(slice);
        Buffers.position(src, src.position() + limit);
    }

    static ByteBuffer allocate(long l) {
        return ByteBuffer.allocate(Math.toIntExact(l));
    }

    static ByteBuffer allocate(int i) {
        return ByteBuffer.allocate(i);
    }

    static ByteBuffer allocateAligned(int size, int alignmentMultiple) {
        int actualSize = Buffers.alignSize(size, alignmentMultiple);
        return Buffers.allocate(actualSize);
    }

    static int alignSize(int size, int alignmentMultiple) {
        int alignedSize = size;
        if (size < alignmentMultiple) {
            alignedSize = alignmentMultiple;
        } else if (size % alignmentMultiple != 0) {
            alignedSize = (size + alignmentMultiple - 1) / alignmentMultiple * alignmentMultiple;
        }
        return alignedSize;
    }
}

