/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.io;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IFileHandle;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.dataflow.common.io.GeneratedRunFileReader;

public class RunFileWriter
implements IFrameWriter {
    private final IIOManager ioManager;
    private FileReference file;
    private boolean failed;
    private IFileHandle handle;
    private long size;
    private int maxOutputFrameSize;

    public RunFileWriter(FileReference file, IIOManager ioManager) {
        this.file = file;
        this.ioManager = ioManager;
    }

    public void open() throws HyracksDataException {
        this.handle = this.ioManager.open(this.file, IIOManager.FileReadWriteMode.READ_WRITE, IIOManager.FileSyncMode.METADATA_ASYNC_DATA_ASYNC);
        this.size = 0L;
        this.failed = false;
        this.maxOutputFrameSize = 0;
    }

    public void rewind() {
        this.size = 0L;
        this.maxOutputFrameSize = 0;
    }

    public void fail() throws HyracksDataException {
        this.ioManager.close(this.handle);
        this.failed = true;
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        int writen = this.ioManager.syncWrite(this.handle, this.size, buffer);
        this.maxOutputFrameSize = Math.max(writen, this.maxOutputFrameSize);
        this.size += (long)writen;
    }

    public void close() throws HyracksDataException {
        if (!this.failed && this.handle != null) {
            this.ioManager.close(this.handle);
        }
    }

    public void erase() throws HyracksDataException {
        try {
            this.close();
        }
        finally {
            this.eraseClosed();
        }
    }

    public void eraseClosed() {
        this.file.delete();
        this.file = null;
        this.handle = null;
    }

    public FileReference getFileReference() {
        return this.file;
    }

    public long getFileSize() {
        return this.size;
    }

    public GeneratedRunFileReader createReader() throws HyracksDataException {
        if (this.failed) {
            throw new HyracksDataException("createReader() called on a failed RunFileWriter");
        }
        return new GeneratedRunFileReader(this.file, this.ioManager, this.size, false, this.maxOutputFrameSize);
    }

    public GeneratedRunFileReader createDeleteOnCloseReader() throws HyracksDataException {
        if (this.failed) {
            throw new HyracksDataException("createReader() called on a failed RunFileWriter");
        }
        return new GeneratedRunFileReader(this.file, this.ioManager, this.size, true, this.maxOutputFrameSize);
    }

    public void flush() throws HyracksDataException {
    }
}

