/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorNodePushable;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexDropOperatorDescriptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexDropOperatorNodePushable
extends AbstractOperatorNodePushable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long DROP_ATTEMPT_WAIT_TIME_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private final IIndexDataflowHelper[] indexHelpers;
    private final Set<IndexDropOperatorDescriptor.DropOption> options;
    private long maxWaitTimeMillis = TimeUnit.SECONDS.toMillis(30L);

    public IndexDropOperatorNodePushable(IIndexDataflowHelperFactory indexHelperFactory, Set<IndexDropOperatorDescriptor.DropOption> options, IHyracksTaskContext ctx, int partition, int[][] partitionsMap) throws HyracksDataException {
        int[] storagePartitions = partitionsMap[partition];
        this.indexHelpers = new IIndexDataflowHelper[storagePartitions.length];
        for (int i = 0; i < storagePartitions.length; ++i) {
            this.indexHelpers[i] = indexHelperFactory.create(ctx.getJobletContext().getServiceContext(), storagePartitions[i]);
        }
        this.options = options;
    }

    public void deinitialize() throws HyracksDataException {
    }

    public int getInputArity() {
        return 0;
    }

    public IFrameWriter getInputFrameWriter(int index) {
        return null;
    }

    public void initialize() throws HyracksDataException {
        for (IIndexDataflowHelper indexHelper : this.indexHelpers) {
            this.dropIndex(indexHelper);
        }
    }

    public void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) {
    }

    private void dropIndex(IIndexDataflowHelper indexHelper) throws HyracksDataException {
        while (true) {
            try {
                indexHelper.destroy();
                return;
            }
            catch (HyracksDataException e) {
                if (this.isIgnorable(e)) {
                    LOGGER.debug("Ignoring exception on drop", (Throwable)e);
                    return;
                }
                if (this.canRetry(e)) {
                    LOGGER.info("Retrying drop on exception", (Throwable)e);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    private boolean isIgnorable(HyracksDataException e) {
        return (e.matches((IError)ErrorCode.INDEX_DOES_NOT_EXIST) || e.matches((IError)ErrorCode.RESOURCE_DOES_NOT_EXIST)) && this.options.contains((Object)IndexDropOperatorDescriptor.DropOption.IF_EXISTS);
    }

    private boolean canRetry(HyracksDataException e) throws HyracksDataException {
        if (e.matches((IError)ErrorCode.CANNOT_DROP_IN_USE_INDEX) && this.options.contains((Object)IndexDropOperatorDescriptor.DropOption.WAIT_ON_IN_USE)) {
            if (this.maxWaitTimeMillis <= 0L) {
                return false;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(DROP_ATTEMPT_WAIT_TIME_MILLIS);
                this.maxWaitTimeMillis -= DROP_ATTEMPT_WAIT_TIME_MILLIS;
                return true;
            }
            catch (InterruptedException e1) {
                throw HyracksDataException.create((Throwable)e1);
            }
        }
        return false;
    }
}

