/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.iceberg.BaseCombinedScanTask;
import org.apache.iceberg.BaseScanTaskGroup;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MergeableScanTask;
import org.apache.iceberg.PartitionScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.SplittableScanTask;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.FluentIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.BinPacking;
import org.apache.iceberg.util.StructLikeMap;
import org.apache.iceberg.util.StructProjection;

public class TableScanUtil {
    private TableScanUtil() {
    }

    public static boolean hasDeletes(CombinedScanTask task) {
        return task.files().stream().anyMatch(TableScanUtil::hasDeletes);
    }

    public static boolean hasEqDeletes(CombinedScanTask task) {
        return task.files().stream().anyMatch(t -> t.deletes().stream().anyMatch(deleteFile -> deleteFile.content().equals((Object)FileContent.EQUALITY_DELETES)));
    }

    public static boolean hasDeletes(FileScanTask task) {
        return !task.deletes().isEmpty();
    }

    public static CloseableIterable<FileScanTask> splitFiles(CloseableIterable<FileScanTask> tasks, long splitSize) {
        Preconditions.checkArgument((splitSize > 0L ? 1 : 0) != 0, (String)"Invalid split size (negative or 0): %s", (long)splitSize);
        FluentIterable splitTasks = FluentIterable.from(tasks).transformAndConcat(input -> input.split(splitSize));
        return CloseableIterable.combine((Iterable)splitTasks, tasks);
    }

    public static CloseableIterable<CombinedScanTask> planTasks(CloseableIterable<FileScanTask> splitFiles, long splitSize, int lookback, long openFileCost) {
        Preconditions.checkArgument((splitSize > 0L ? 1 : 0) != 0, (String)"Invalid split size (negative or 0): %s", (long)splitSize);
        Preconditions.checkArgument((lookback > 0 ? 1 : 0) != 0, (String)"Invalid split planning lookback (negative or 0): %s", (int)lookback);
        Preconditions.checkArgument((openFileCost >= 0L ? 1 : 0) != 0, (String)"Invalid file open cost (negative): %s", (long)openFileCost);
        Function<FileScanTask, Long> weightFunc = file -> Math.max(file.length() + file.deletes().stream().mapToLong(ContentFile::fileSizeInBytes).sum(), (long)(1 + file.deletes().size()) * openFileCost);
        return CloseableIterable.transform((CloseableIterable)CloseableIterable.combine(new BinPacking.PackingIterable<FileScanTask>((Iterable<FileScanTask>)splitFiles, splitSize, lookback, weightFunc, true), splitFiles), BaseCombinedScanTask::new);
    }

    public static <T extends ScanTask> CloseableIterable<ScanTaskGroup<T>> planTaskGroups(CloseableIterable<T> tasks, long splitSize, int lookback, long openFileCost) {
        Preconditions.checkArgument((splitSize > 0L ? 1 : 0) != 0, (String)"Invalid split size (negative or 0): %s", (long)splitSize);
        Preconditions.checkArgument((lookback > 0 ? 1 : 0) != 0, (String)"Invalid split planning lookback (negative or 0): %s", (int)lookback);
        Preconditions.checkArgument((openFileCost >= 0L ? 1 : 0) != 0, (String)"Invalid file open cost (negative): %s", (long)openFileCost);
        CloseableIterable splitTasks = CloseableIterable.combine((Iterable)FluentIterable.from(tasks).transformAndConcat(task -> {
            if (task instanceof SplittableScanTask) {
                return ((SplittableScanTask)task).split(splitSize);
            }
            return ImmutableList.of((Object)task);
        }), tasks);
        Function<ScanTask, Long> weightFunc = task -> Math.max(task.sizeBytes(), (long)task.filesCount() * openFileCost);
        return CloseableIterable.transform((CloseableIterable)CloseableIterable.combine(new BinPacking.PackingIterable<ScanTask>((Iterable<ScanTask>)splitTasks, splitSize, lookback, weightFunc, true), (Closeable)splitTasks), combinedTasks -> new BaseScanTaskGroup(TableScanUtil.mergeTasks(combinedTasks)));
    }

    public static <T extends PartitionScanTask> List<ScanTaskGroup<T>> planTaskGroups(List<T> tasks, long splitSize, int lookback, long openFileCost, Types.StructType projectedPartitionType) {
        Preconditions.checkArgument((splitSize > 0L ? 1 : 0) != 0, (String)"Invalid split size (negative or 0): %s", (long)splitSize);
        Preconditions.checkArgument((lookback > 0 ? 1 : 0) != 0, (String)"Invalid split planning lookback (negative or 0): %s", (int)lookback);
        Preconditions.checkArgument((openFileCost >= 0L ? 1 : 0) != 0, (String)"Invalid file open cost (negative): %s", (long)openFileCost);
        Function<PartitionScanTask, Long> weightFunc = task -> Math.max(task.sizeBytes(), (long)task.filesCount() * openFileCost);
        HashMap projectionsBySpec = Maps.newHashMap();
        StructLikeMap tasksByPartition = StructLikeMap.create(projectedPartitionType);
        for (PartitionScanTask task2 : tasks) {
            PartitionSpec spec = task2.spec();
            StructProjection projectedStruct = projectionsBySpec.computeIfAbsent(spec.specId(), specId -> StructProjection.create((Types.StructType)spec.partitionType(), (Types.StructType)projectedPartitionType));
            List taskList = tasksByPartition.computeIfAbsent(projectedStruct.copyFor(task2.partition()), k -> Lists.newArrayList());
            if (task2 instanceof SplittableScanTask) {
                ((SplittableScanTask)task2).split(splitSize).forEach(taskList::add);
                continue;
            }
            taskList.add(task2);
        }
        return FluentIterable.from(tasksByPartition.values()).transformAndConcat(ts -> TableScanUtil.toTaskGroupIterable(ts, splitSize, lookback, weightFunc)).toList();
    }

    private static <T extends ScanTask> Iterable<ScanTaskGroup<T>> toTaskGroupIterable(Iterable<T> tasks, long splitSize, int lookback, Function<T, Long> weightFunc) {
        return Iterables.transform(new BinPacking.PackingIterable<T>(tasks, splitSize, lookback, weightFunc, true), combinedTasks -> new BaseScanTaskGroup(TableScanUtil.mergeTasks(combinedTasks)));
    }

    public static <T extends ScanTask> List<T> mergeTasks(List<T> tasks) {
        ArrayList mergedTasks = Lists.newArrayList();
        ScanTask lastTask = null;
        for (ScanTask task : tasks) {
            if (lastTask != null) {
                if (lastTask instanceof MergeableScanTask) {
                    MergeableScanTask mergeableLastTask = (MergeableScanTask)lastTask;
                    if (mergeableLastTask.canMerge(task)) {
                        lastTask = (ScanTask)mergeableLastTask.merge(task);
                        continue;
                    }
                    mergedTasks.add(lastTask);
                    lastTask = task;
                    continue;
                }
                mergedTasks.add(lastTask);
                lastTask = task;
                continue;
            }
            lastTask = task;
        }
        if (lastTask != null) {
            mergedTasks.add(lastTask);
        }
        return mergedTasks;
    }
}

